/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.exception;

import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.interceptor.Fault;
import org.mule.soap.internal.util.XmlTransformationException;
import org.mule.soap.internal.util.XmlTransformationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class SoapFaultException
extends RuntimeException {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapFaultException.class);
    private final QName faultCode;
    private final QName subCode;
    private final String detail;
    private final String reason;
    private final String node;
    private final String role;
    private Map<String, String> additionalTransportData;

    public SoapFaultException(QName code, QName subCode, String detail, String reason, String node, String role, Throwable cause) {
        super(reason, cause);
        this.faultCode = code;
        this.subCode = subCode;
        this.reason = reason;
        this.node = node;
        this.role = role;
        this.detail = detail;
    }

    public SoapFaultException(SoapFault f) {
        this(f.getFaultCode(), f.getSubCode(), SoapFaultException.parseExceptionDetail(f.getDetail()), f.getReason(), f.getNode(), f.getRole(), f);
    }

    public SoapFaultException(SoapFault f, Map<String, String> additionalTransportData) {
        this(f.getFaultCode(), f.getSubCode(), SoapFaultException.parseExceptionDetail(f.getDetail()), f.getReason(), f.getNode(), f.getRole(), f);
        this.additionalTransportData = additionalTransportData;
    }

    public SoapFaultException(Fault f) {
        this(f.getFaultCode(), null, SoapFaultException.parseExceptionDetail(f.getDetail()), "", null, null, f);
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public String getReason() {
        return this.reason;
    }

    public Optional<QName> getSubCode() {
        return Optional.ofNullable(this.subCode);
    }

    public String getDetail() {
        return this.detail;
    }

    public Optional<String> getNode() {
        return Optional.ofNullable(this.node);
    }

    public Optional<String> getRole() {
        return Optional.ofNullable(this.role);
    }

    private static String parseExceptionDetail(Element detail) {
        try {
            return XmlTransformationUtils.nodeToString(detail);
        }
        catch (XmlTransformationException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error while parsing Soap Exception detail: " + detail.toString(), (Throwable)e);
            }
            return "";
        }
    }

    @Override
    public String toString() {
        return "SoapFault{faultCode=" + this.faultCode + ", subCode=" + this.subCode + ", detail='" + this.detail + '\'' + ", reason='" + this.reason + '\'' + ", node='" + this.node + '\'' + ", role='" + this.role + '\'' + '}';
    }
}

