/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.interceptor;

import java.util.ArrayList;
import java.util.List;
import javanet.staxutils.events.EventAllocator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import org.mule.soap.internal.xml.stax.DelegateXMLStreamReader;

public class ScopeSaverXMLStreamReader
extends DelegateXMLStreamReader {
    private final XMLEventAllocator allocator = new EventAllocator();
    private List<StartElement> scope = new ArrayList<StartElement>();
    private boolean first = true;

    public ScopeSaverXMLStreamReader(XMLStreamReader reader) {
        super(reader);
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.first) {
            this.first = false;
            if (this.getEventType() == 1) {
                XMLEvent evt = this.allocator.allocate(this);
                this.scope.add(evt.asStartElement());
            }
        }
        int res = super.next();
        switch (res) {
            case 1: {
                XMLEvent evt = this.allocator.allocate(this);
                this.scope.add(evt.asStartElement());
                break;
            }
            case 2: {
                this.scope.remove(this.scope.size() - 1);
                break;
            }
        }
        return res;
    }

    public StartElement currentScope() {
        if (this.scope.size() > 0) {
            throw new IllegalArgumentException("No scope available");
        }
        return this.scope.get(this.scope.size() - 1);
    }

    public List<StartElement> scopes() {
        return this.scope;
    }
}

