/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.wss4j.common.crypto.Merlin;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.api.security.stores.WssTrustStoreConfiguration;
import org.mule.soap.internal.security.callback.WSPasswordCallbackHandler;

public class WssVerifySignatureSecurityStrategy
implements SecurityStrategy {
    private static final String WS_VERIFY_SIGNATURE_PROPERTIES_KEY = "verifySignatureProperties";
    private final WssTrustStoreConfiguration trustStoreConfiguration;

    public WssVerifySignatureSecurityStrategy(WssTrustStoreConfiguration trustStoreConfiguration) {
        this.trustStoreConfiguration = trustStoreConfiguration;
    }

    public WssVerifySignatureSecurityStrategy() {
        this.trustStoreConfiguration = null;
    }

    @Override
    public SecurityStrategy.SecurityStrategyType securityType() {
        return SecurityStrategy.SecurityStrategyType.INCOMING;
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.empty();
    }

    @Override
    public String securityAction() {
        return "Signature";
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        Properties signatureProps = this.trustStoreConfiguration != null ? this.trustStoreConfiguration.getConfigurationProperties() : this.getDefaultTrustStoreConfigurationProperties();
        return ImmutableMap.builder().put((Object)"signaturePropRefId", (Object)WS_VERIFY_SIGNATURE_PROPERTIES_KEY).put((Object)WS_VERIFY_SIGNATURE_PROPERTIES_KEY, (Object)signatureProps).build();
    }

    private Properties getDefaultTrustStoreConfigurationProperties() {
        Properties properties = new Properties();
        properties.setProperty("org.apache.wss4j.crypto.provider", Merlin.class.getCanonicalName());
        properties.setProperty("load.cacerts", String.valueOf(true));
        return properties;
    }
}

