/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.api.security.stores.WssKeyStoreConfiguration;
import org.mule.soap.internal.security.callback.WSPasswordCallbackHandler;

public class WssEncryptSecurityStrategy
implements SecurityStrategy {
    private static final String WS_ENCRYPT_PROPERTIES_KEY = "encryptProperties";
    private WssKeyStoreConfiguration keyStoreConfiguration;

    public WssEncryptSecurityStrategy(WssKeyStoreConfiguration keyStoreConfiguration) {
        this.keyStoreConfiguration = keyStoreConfiguration;
    }

    @Override
    public SecurityStrategy.SecurityStrategyType securityType() {
        return SecurityStrategy.SecurityStrategyType.OUTGOING;
    }

    @Override
    public String securityAction() {
        return "Encrypt";
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.empty();
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        return ImmutableMap.builder().put((Object)"encryptionPropRefId", (Object)WS_ENCRYPT_PROPERTIES_KEY).put((Object)WS_ENCRYPT_PROPERTIES_KEY, (Object)this.keyStoreConfiguration.getConfigurationProperties()).put((Object)"encryptionUser", (Object)this.keyStoreConfiguration.getAlias()).build();
    }
}

