/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api.message;

import java.nio.charset.Charset;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.destination.JmsDestination;
import org.mule.jms.commons.api.exception.DestinationNotFoundException;
import org.mule.jms.commons.api.message.JmsMessageBuilder;
import org.mule.jms.commons.api.message.JmsxProperties;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.message.JMSXDefinedPropertiesNames;
import org.mule.jms.commons.internal.message.JmsMessageUtils;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessageFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageFactory.class);
    public static final String BODY_CONTENT_TYPE_JMS_PROPERTY = "MM_MESSAGE_CONTENT_TYPE";
    public static final String BODY_ENCODING_JMS_PROPERTY = "MM_MESSAGE_ENCODING";

    public static Message build(JmsSupport jmsSupport, OutboundCorrelationStrategy outboundCorrelationStrategy, CorrelationInfo correlationInfo, Session session, JmsConfig config, JmsMessageBuilder messageBuilder) throws JMSException {
        TypedValue<Object> body = messageBuilder.getBody();
        Message message = JmsMessageUtils.toMessage(body, session, JmsCommons.resolveOverride(config.getEncoding(), messageBuilder.getOutboundEncoding()));
        JmsMessageFactory.setJmsCorrelationIdHeader(message, outboundCorrelationStrategy, correlationInfo, messageBuilder.getCorrelationId());
        JmsMessageFactory.setJmsTypeHeader(message, messageBuilder.getJmsType());
        JmsMessageFactory.setJmsReplyToHeader(jmsSupport, session, message, messageBuilder.getReplyTo(), config);
        JmsMessageFactory.setJmsxProperties(message, messageBuilder.getJmsxProperties());
        JmsMessageFactory.setUserProperties(message, messageBuilder.getProperties());
        if (messageBuilder.isSendContentType()) {
            JmsMessageFactory.setContentTypeProperty(message, body.getDataType(), messageBuilder.getOutboundContentType());
        }
        if (messageBuilder.isSendEncoding()) {
            JmsMessageFactory.setEncodingProperty(message, body.getDataType(), JmsCommons.resolveOverride(config.getEncoding(), messageBuilder.getOutboundEncoding()));
        }
        return message;
    }

    private static void setJmsReplyToHeader(JmsSupport jmsSupport, Session session, Message message, JmsDestination replyDestination, JmsConfig config) {
        try {
            if (replyDestination != null && !StringUtils.isBlank((CharSequence)replyDestination.getDestination())) {
                Destination destination = jmsSupport.createDestination(session, replyDestination.getDestination(), replyDestination.getDestinationType().isTopic(), config);
                message.setJMSReplyTo(destination);
            }
        }
        catch (JMSException | DestinationNotFoundException e) {
            LOGGER.error("Unable to set JMSReplyTo header: ", (Throwable)e);
        }
    }

    private static void setEncodingProperty(Message message, DataType dataType, String defaultEncoding) {
        try {
            message.setStringProperty(BODY_ENCODING_JMS_PROPERTY, dataType.getMediaType().getCharset().map(Charset::toString).orElse(defaultEncoding));
        }
        catch (JMSException e) {
            LOGGER.error(String.format("Unable to set property [%s] of type String: ", BODY_ENCODING_JMS_PROPERTY), (Throwable)e);
        }
    }

    private static void setContentTypeProperty(Message message, DataType dataType, String outboundContentType) {
        try {
            String value = StringUtils.isBlank((CharSequence)outboundContentType) ? dataType.getMediaType().toRfcString() : outboundContentType;
            message.setStringProperty(BODY_CONTENT_TYPE_JMS_PROPERTY, value);
        }
        catch (JMSException e) {
            LOGGER.error(String.format("Unable to set property [%s] of type String: ", BODY_CONTENT_TYPE_JMS_PROPERTY), (Throwable)e);
        }
    }

    private static void setJmsxProperties(Message message, JmsxProperties jmsxProperties) {
        jmsxProperties.asMap().entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> JmsMessageFactory.setJmsPropertySanitizeKeyIfNecessary(message, (String)e.getKey(), e.getValue()));
    }

    private static void setUserProperties(Message message, Map<String, Object> properties) {
        properties.keySet().stream().filter(key -> !StringUtils.isBlank((CharSequence)key) && !JMSXDefinedPropertiesNames.JMSX_NAMES.contains(key)).forEach(key -> JmsMessageFactory.setJmsPropertySanitizeKeyIfNecessary(message, key, properties.get(key)));
    }

    private static void setJmsPropertySanitizeKeyIfNecessary(Message msg, String key, Object value) {
        block3: {
            try {
                key = JmsMessageUtils.encodeKey(key);
                if (value instanceof TypedValue) {
                    value = ((TypedValue)value).getValue();
                }
                msg.setObjectProperty(key, value);
            }
            catch (JMSException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug(String.format("Unable to set property [%s] of type [%s]: ", key, value.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }

    private static void setJmsTypeHeader(Message message, String jmsType) {
        try {
            if (!StringUtils.isBlank((CharSequence)jmsType)) {
                message.setJMSType(jmsType);
            }
        }
        catch (JMSException e) {
            LOGGER.error("An error occurred while setting the JMSType property: %s", (Throwable)e);
        }
    }

    private static void setJmsCorrelationIdHeader(Message message, OutboundCorrelationStrategy outboundCorrelationStrategy, CorrelationInfo correlationInfo, String correlationId) {
        outboundCorrelationStrategy.getOutboundCorrelationId(correlationInfo, correlationId).ifPresent(id -> {
            try {
                message.setJMSCorrelationID(id);
            }
            catch (JMSException e) {
                LOGGER.error("An error occurred while setting the JMSCorrelationID property: %s", (Throwable)e);
            }
        });
    }
}

