/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source.push;

import org.mule.jms.commons.api.message.DefaultJmsAttributes;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.source.JmsConnectionExceptionResolver;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.jms.commons.internal.source.push.JmsListenerSession;
import org.mule.jms.commons.internal.source.push.JmsMessageListener;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public final class JmsMessageListenerFactory<T extends DefaultJmsAttributes> {
    private final InternalAckMode ackMode;
    private final String encoding;
    private final String contentType;
    private final JmsConnectionExceptionResolver exceptionResolver;
    private JmsConfig config;
    private final JmsSessionManager sessionManager;
    private JmsSupport jmsSupport;
    private SourceCallback<Object, T> sourceCallback;
    private ConnectionProvider<JmsTransactionalConnection> connectionProvider;

    public JmsMessageListenerFactory(InternalAckMode ackMode, String encoding, String contentType, JmsConfig config, JmsSessionManager sessionManager, JmsSupport jmsSupport, SourceCallback<Object, T> sourceCallback, ConnectionProvider<JmsTransactionalConnection> connectionProvider, JmsConnectionExceptionResolver exceptionResolver) {
        this.ackMode = ackMode;
        this.encoding = encoding;
        this.contentType = contentType;
        this.config = config;
        this.sessionManager = sessionManager;
        this.jmsSupport = jmsSupport;
        this.sourceCallback = sourceCallback;
        this.connectionProvider = connectionProvider;
        this.exceptionResolver = exceptionResolver;
    }

    public JmsMessageListener createMessageListener(JmsSession session, JmsListenerLock jmsLock) {
        return new JmsMessageListener<T>(new JmsListenerSession(session), this.config, jmsLock, this.sessionManager, this.sourceCallback, this.jmsSupport.getSpecification(), this.ackMode, this.encoding, this.contentType, this.connectionProvider, this.exceptionResolver);
    }
}

