/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.publish;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.jms.CompletionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.internal.publish.PublisherParameters;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageProducer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageProducer.class);
    private final MessageProducer producer;
    private final JmsSupport jmsSupport;
    private final boolean isTopic;

    public JmsMessageProducer(JmsSupport jmsSupport, MessageProducer producer, boolean isTopic) {
        Preconditions.checkArgument((jmsSupport != null ? 1 : 0) != 0, (String)"A non null JmsSupport implementation is required for publishing");
        Preconditions.checkArgument((producer != null ? 1 : 0) != 0, (String)"A non null MessageProducer is required to use as delegate");
        this.producer = producer;
        this.jmsSupport = jmsSupport;
        this.isTopic = isTopic;
    }

    public void publish(Message message, PublisherParameters overrides) throws JMSException {
        Optional<Long> delay = this.resolveDeliveryDelay(overrides.getDeliveryDelay(), overrides.getDeliveryDelayUnit());
        long timeToLive = overrides.getTimeToLiveUnit().toMillis(overrides.getTimeToLive());
        this.configureProducer(delay, overrides.isDisableMessageId(), overrides.isDisableMessageTimestamp());
        this.jmsSupport.send(this.producer, message, overrides.isPersistentDelivery(), overrides.getPriority(), timeToLive, this.isTopic);
    }

    public void publish(Message message, PublisherParameters overrides, CompletionListener completionListener) throws JMSException {
        Optional<Long> delay = this.resolveDeliveryDelay(overrides.getDeliveryDelay(), overrides.getDeliveryDelayUnit());
        long timeToLive = overrides.getTimeToLiveUnit().toMillis(overrides.getTimeToLive());
        this.configureProducer(delay, overrides.isDisableMessageId(), overrides.isDisableMessageTimestamp());
        this.jmsSupport.send(this.producer, message, overrides.isPersistentDelivery(), overrides.getPriority(), timeToLive, this.isTopic, completionListener);
    }

    @Override
    public void close() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing producer: " + this.producer);
        }
        this.producer.close();
    }

    private Optional<Long> resolveDeliveryDelay(Long delay, TimeUnit delayUnit) {
        Preconditions.checkArgument((this.jmsSupport.getSpecification().equals((Object)JmsSpecification.JMS_2_0) || delay == null ? 1 : 0) != 0, (String)String.format("[deliveryDelay] is only supported on [JMS 2.0] specification, but current configuration is set to [JMS %s]", this.jmsSupport.getSpecification().getName()));
        return delay != null ? Optional.of(delayUnit.toMillis(delay)) : Optional.empty();
    }

    private void configureProducer(Optional<Long> deliveryDelay, boolean dissableId, boolean dissableTimeStamp) throws JMSException {
        this.setDisableMessageID(dissableId);
        this.setDisableMessageTimestamp(dissableTimeStamp);
        deliveryDelay.ifPresent(this::setDeliveryDelay);
    }

    private void setDeliveryDelay(Long value) {
        try {
            this.producer.setDeliveryDelay(value.longValue());
        }
        catch (JMSException e) {
            LOGGER.error("Failed to configure [setDeliveryDelay] in MessageProducer: " + e.getMessage(), (Throwable)e);
        }
    }

    private void setDisableMessageID(boolean value) {
        try {
            this.producer.setDisableMessageID(value);
        }
        catch (JMSException e) {
            LOGGER.error("Failed to configure [setDisableMessageID] in MessageProducer: " + e.getMessage(), (Throwable)e);
        }
    }

    private void setDisableMessageTimestamp(boolean value) {
        try {
            this.producer.setDisableMessageTimestamp(value);
        }
        catch (JMSException e) {
            LOGGER.error("Failed to configure [setDisableMessageTimestamp] in MessageProducer: " + e.getMessage(), (Throwable)e);
        }
    }
}

