/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection;

import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsXaContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsXaContext.class);
    private final XAResource xaResource;
    private final AtomicReference<Runnable> runnableRef = new AtomicReference();

    public JmsXaContext(XAResource xaResource) {
        this.xaResource = xaResource;
    }

    public XAResource getXaResource() {
        return this.xaResource;
    }

    public void end() {
        LOGGER.debug("{} # end()", (Object)this);
        Runnable runnable = this.runnableRef.get();
        if (runnable != null) {
            runnable.run();
        }
    }

    public void afterEnds(Runnable runnable) {
        this.runnableRef.set(runnable);
    }

    public String toString() {
        return "JmsXaContext{xaResource: " + this.xaResource.toString() + "}@" + Integer.toHexString(this.hashCode());
    }
}

