/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source.push;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.api.lock.JmsListenerLockFactory;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.jms.commons.internal.source.JmsResourceReleaser;
import org.mule.jms.commons.internal.source.MessageConsumerDelegate;
import org.mule.jms.commons.internal.source.push.JmsMessageListener;
import org.mule.jms.commons.internal.source.push.JmsMessageListenerFactory;
import org.mule.jms.commons.internal.source.push.MessageListenerContext;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessageListenerDelegate
implements MessageConsumerDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageListenerDelegate.class);
    private JmsMessageListenerFactory messageListenerFactory;
    private JmsConnection connection;
    private final JmsSupport jmsSupport;
    private final ConsumerType consumerType;
    private final String destination;
    private final JmsConfig config;
    private final InternalAckMode resolvedAckMode;
    private final String selector;
    private final List<MessageListenerContext> createdListeners = new ArrayList<MessageListenerContext>();
    private final JmsResourceReleaser resourceCleaner;
    private final JmsListenerLockFactory lockFactory;
    static final String JMS_LOCK_VAR = "JMS_LOCK";

    public JmsMessageListenerDelegate(JmsMessageListenerFactory messageListenerFactory, JmsConnection connection, JmsSupport jmsSupport, ConsumerType consumerType, String destination, JmsConfig config, InternalAckMode resolvedAckMode, String selector, JmsListenerLockFactory lockFactory, JmsResourceReleaser resourceCleaner) {
        this.messageListenerFactory = messageListenerFactory;
        this.connection = connection;
        this.jmsSupport = jmsSupport;
        this.consumerType = consumerType;
        this.destination = destination;
        this.config = config;
        this.resolvedAckMode = resolvedAckMode;
        this.selector = selector;
        this.lockFactory = lockFactory;
        this.resourceCleaner = resourceCleaner;
    }

    private MessageListenerContext createMessageConsumer() throws Exception {
        JmsMessageConsumer consumer;
        JmsSession session = this.connection.createSession(this.resolvedAckMode, this.consumerType.topic());
        Destination jmsDestination = this.jmsSupport.createDestination(session.get(), this.destination, this.consumerType.topic(), this.config);
        try {
            consumer = this.connection.createConsumer(session, jmsDestination, this.selector, this.consumerType);
        }
        catch (JMSException | JmsExtensionException e) {
            session.close();
            throw e;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Creating Message Listener on Session [%s] for destination [%s]", session.get(), this.destination));
        }
        JmsListenerLock jmsLock = this.lockFactory.createLock(this.resolvedAckMode);
        JmsMessageListener listener = this.messageListenerFactory.createMessageListener(session, jmsLock);
        consumer.listen(listener);
        return new MessageListenerContext(session, jmsLock, consumer, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createConsumers(int numberOfConsumers) throws ConnectionException {
        try {
            this.lockFactory.setEnabled(true);
            List<MessageListenerContext> list = this.createdListeners;
            synchronized (list) {
                for (int i = 0; i < numberOfConsumers; ++i) {
                    this.createdListeners.add(this.createMessageConsumer());
                }
            }
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while creating the consumers for destination [%s:%s]: %s", JmsCommons.getDestinationType(this.consumerType), this.destination, e.getMessage());
            LOGGER.error(msg, (Throwable)e);
            this.stop();
            throw new ConnectionException(msg, (Throwable)e, null, (Object)this.connection);
        }
    }

    @Override
    public void onSuccess(SourceCallbackContext callbackContext) {
        callbackContext.getVariable(JMS_LOCK_VAR).ifPresent(JmsListenerLock::unlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<MessageListenerContext> list = this.createdListeners;
        synchronized (list) {
            try {
                this.createdListeners.forEach(this::closeConsumerQuietly);
            }
            finally {
                this.createdListeners.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableConsumers() {
        List<MessageListenerContext> list = this.createdListeners;
        synchronized (list) {
            this.createdListeners.forEach(info -> this.disableConsumerListener((MessageListenerContext)info));
        }
    }

    protected void disableConsumerListener(MessageListenerContext info) {
        this.resourceCleaner.releaseConsumerMessageListener(info);
    }

    protected void closeConsumerQuietly(MessageListenerContext info) {
        try {
            this.closeConsumer(info);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to close consumer %s", (Object)info.getConsumer());
        }
        finally {
            JmsCommons.closeQuietly(info.getSession());
        }
    }

    private void closeConsumer(MessageListenerContext info) {
        try {
            this.disableConsumerListener(info);
        }
        finally {
            info.getLock().unlockWithFailure();
            JmsCommons.closeQuietly(info.getConsumer());
        }
    }

    @Override
    public void onError(SourceCallbackContext callbackContext, Error error) {
        callbackContext.getVariable(JMS_LOCK_VAR).ifPresent(jmsLock -> {
            if (this.resolvedAckMode.equals((Object)InternalAckMode.AUTO) || this.resolvedAckMode.equals((Object)InternalAckMode.DUPS_OK)) {
                jmsLock.unlockWithFailure(error);
            } else {
                jmsLock.unlock();
            }
        });
    }
}

