/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.AbstractDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;

public class ResolvedDbType
extends AbstractDbType {
    private static final String ORACLE_JDBC_PREFIX = "oracle";
    public static final String DATE_TYPE_REGEX = "\\d{4}-\\d{2}-\\d{2}";
    public static final Pattern DATE_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    private boolean statementIsComplete;

    public ResolvedDbType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        if (value == null) {
            statement.setNull(index, this.id);
            return;
        }
        value = UnknownDbType.createArraysAndStructs(value, connection);
        this.statementIsComplete = false;
        if (this.isValidDriverName(statement) && statement.getConnection().getMetaData().getDriverName().toLowerCase().contains(ORACLE_JDBC_PREFIX.toLowerCase())) {
            this.oracleResolveParameterValue(statement, index, value);
        }
        if (!this.statementIsComplete) {
            if (3 == this.id || 2 == this.id) {
                if (value instanceof BigDecimal) {
                    statement.setObject(index, value, this.id, ((BigDecimal)value).scale());
                } else if (value instanceof Float || value instanceof Double) {
                    BigDecimal bigDecimal = new BigDecimal(value.toString());
                    statement.setObject(index, (Object)bigDecimal, this.id, bigDecimal.scale());
                } else if (value instanceof String) {
                    BigDecimal bigDecimal = new BigDecimal((String)value);
                    statement.setObject(index, (Object)bigDecimal, this.id, bigDecimal.scale());
                } else {
                    statement.setObject(index, value, this.id);
                }
            } else {
                statement.setObject(index, value, this.id);
            }
        }
    }

    @Override
    public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
        return statement.getObject(index);
    }

    private void oracleResolveParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        String strValue;
        if (this.id == 91) {
            statement.setObject(index, value);
            this.statementIsComplete = true;
        } else if (this.id == 93 && value instanceof String && DATE_PATTERN.matcher(strValue = (String)value).matches()) {
            statement.setObject(index, value);
            this.statementIsComplete = true;
        }
    }

    private boolean isValidDriverName(PreparedStatement statement) throws SQLException {
        return statement != null && statement.getConnection() != null && statement.getConnection().getMetaData() != null && statement.getConnection().getMetaData().getDriverName() != null;
    }
}

