/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.result.row;

import org.mule.db.commons.internal.domain.connection.DbConnection;

import java.nio.charset.Charset;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

/**
 * Maps a row using returning a case insensitive map
 */
public class InsensitiveMapRowHandler extends AbstractMapRowHandler {

  public InsensitiveMapRowHandler(DbConnection dbConnection) {
    super(dbConnection);
  }

  public InsensitiveMapRowHandler(DbConnection dbConnection, Charset charset) {
    super(dbConnection, charset);
  }

  @Override
  protected String getColumnKey(ResultSetMetaData metaData, int columnIndex) throws SQLException {
    return metaData.getColumnLabel(columnIndex);
  }

  @Override
  protected void validateResult(Map<String, Object> result, int columnCount) throws SQLException {
    if (columnCount != result.size()) {
      throw new IllegalArgumentException("Record cannot be mapped as it contains multiple columns with the same label. Define column aliases to solve this problem");
    }
  }

}
