/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.result.row;

import org.mule.db.commons.internal.domain.connection.DbConnection;

import java.nio.charset.Charset;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

/**
 * Maps a row using column numbers as keys instead of column names. This avoids the duplicate column label exception by using
 * column indices.
 */
public class ColumnNumberMapRowHandler extends AbstractMapRowHandler {

  public ColumnNumberMapRowHandler(DbConnection dbConnection) {
    super(dbConnection);
  }

  public ColumnNumberMapRowHandler(DbConnection dbConnection, Charset charset) {
    super(dbConnection, charset);
  }

  @Override
  protected String getColumnKey(ResultSetMetaData metaData, int columnIndex) throws SQLException {
    // Use column number as key instead of column label
    return String.valueOf(columnIndex);
  }

}
