/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.logger;

import org.mule.db.commons.internal.domain.param.InputQueryParam;

/**
 * Logs a single query
 */
public interface SingleQueryLogger extends QueryLogger {

  /**
   * Adds the value of a query parameter for logging
   *
   * @param param non null parameter to log
   * @param value value to log
   */
  void addParameter(InputQueryParam param, Object value);
}
