/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.logger;

import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.slf4j.Logger;

/**
 * Creates {@link QueryLogger} instances
 */
public interface QueryLoggerFactory {

  /**
   * Creates a logger for a single query
   *
   * @param logger        logger where the query will be logged
   * @param queryTemplate query tepmlate to log
   * @return a non null {@link SingleQueryLogger}
   */
  SingleQueryLogger createQueryLogger(Logger logger, QueryTemplate queryTemplate);

  /**
   * Creates a logger for a single query running in bulk mode
   *
   * @param logger        logger where the query will be logged
   * @param queryTemplate query tepmlate to log
   * @param bulkSize      total size of the bulk operation. Must be positive
   * @return a non null {@link PreparedBulkQueryLogger}
   */
  PreparedBulkQueryLogger createBulkQueryLogger(Logger logger, QueryTemplate queryTemplate, int bulkSize);

  /**
   * Creates a logger for a bulk query
   *
   * @param logger logger where the query will be logged
   * @return a non null {@link BulkQueryLogger}
   */
  BulkQueryLogger createBulkQueryLogger(Logger logger);
}
