/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons;

import org.mule.db.commons.api.param.JdbcType;
import org.mule.db.commons.internal.domain.type.CompositeDbTypeManager;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.MetadataDbTypeManager;
import org.mule.db.commons.internal.domain.type.StaticDbTypeManager;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDbConnector implements Initialisable {

  @DefaultEncoding
  protected String encoding;

  protected Charset charset;

  protected DbTypeManager typeManager;

  @Override
  public void initialise() throws InitialisationException {
    typeManager = createBaseTypeManager();
    charset = Charset.forName(encoding);
  }

  public DbTypeManager getTypeManager() {
    return typeManager;
  }

  public Charset getCharset() {
    return charset;
  }

  protected DbTypeManager createBaseTypeManager() {
    List<DbTypeManager> typeManagers = new ArrayList<>();
    typeManagers.add(new MetadataDbTypeManager());
    typeManagers.add(new StaticDbTypeManager(JdbcType.getAllTypes()));

    return new CompositeDbTypeManager(typeManagers);
  }
}
