/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.logger;

import org.mule.db.commons.internal.domain.logger.DebugSingleQueryLogger;
import org.mule.db.commons.internal.domain.logger.PreparedBulkQueryLogger;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.slf4j.Logger;

public class DebugPreparedBulkQueryLogger
extends DebugSingleQueryLogger
implements PreparedBulkQueryLogger {
    public static final String PARAMETER_SET_BEGIN = "\n{";
    public static final String PARAMETER_SET_END = "\n}";
    private final int bulkSize;
    private int currentBulkSize = 0;

    public DebugPreparedBulkQueryLogger(Logger logger, QueryTemplate queryTemplate, int bulkSize) {
        super(logger, queryTemplate);
        this.bulkSize = bulkSize;
        if (this.hasParameters()) {
            this.builder.append(PARAMETER_SET_BEGIN);
        }
    }

    @Override
    public void addParameterSet() {
        ++this.currentBulkSize;
        if (this.hasParameters()) {
            this.builder.append(PARAMETER_SET_END);
            if (this.currentBulkSize < this.bulkSize) {
                this.builder.append(PARAMETER_SET_BEGIN);
            }
        }
    }
}

