/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.autogeneratedkey;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;

public class ColumnNameAutoGenerateKeysStrategy
implements AutoGenerateKeysStrategy {
    private final String[] columnNames;

    public ColumnNameAutoGenerateKeysStrategy(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public boolean returnsAutoGenerateKeys() {
        return true;
    }

    @Override
    public PreparedStatement prepareStatement(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        return connection.getJdbcConnection().prepareStatement(queryTemplate.getSqlText(), this.columnNames);
    }

    @Override
    public boolean execute(Statement statement, QueryTemplate queryTemplate) throws SQLException {
        if (statement instanceof PreparedStatement) {
            return ((PreparedStatement)statement).execute();
        }
        return statement.execute(queryTemplate.getSqlText(), this.columnNames);
    }

    @Override
    public int executeUpdate(Statement statement, QueryTemplate queryTemplate) throws SQLException {
        if (statement instanceof PreparedStatement) {
            return ((PreparedStatement)statement).executeUpdate();
        }
        return statement.executeUpdate(queryTemplate.getSqlText(), this.columnNames);
    }
}

