/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.db.commons.internal.domain.query.QueryType;

public abstract class AbstractStatementTypeDetector {
    protected static final String OPERATION_REGEX_TEMPLATE = "(?ms)%s\\s++.+";
    protected final QueryType QUERY_TYPE;
    protected final String DETECTION_REGEX;
    private final Pattern detectionPattern;

    protected AbstractStatementTypeDetector(QueryType detectsQueryType, String detectionRegex) {
        this.QUERY_TYPE = detectsQueryType;
        this.DETECTION_REGEX = detectionRegex;
        this.detectionPattern = Pattern.compile(this.DETECTION_REGEX);
    }

    public boolean isOfType(String sql) {
        Matcher m = this.detectionPattern.matcher(this.cleanup(sql));
        return m.matches();
    }

    public QueryType getType() {
        return this.QUERY_TYPE;
    }

    protected String cleanup(String sql) {
        return sql.trim().toUpperCase();
    }
}

