/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.AbstractDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvedDbType
extends AbstractDbType {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ResolvedDbType.class);
    private static final int ORACLE_TIMESTAMPLTZ_ID = -102;

    public ResolvedDbType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        if (value == null) {
            statement.setNull(index, this.id);
            return;
        }
        value = UnknownDbType.createArraysAndStructs(value, connection);
        if (3 == this.id || 2 == this.id) {
            if (value instanceof BigDecimal) {
                statement.setObject(index, value, this.id, ((BigDecimal)value).scale());
            } else if (value instanceof Float || value instanceof Double) {
                BigDecimal bigDecimal = new BigDecimal(value.toString());
                statement.setObject(index, (Object)bigDecimal, this.id, bigDecimal.scale());
            } else if (value instanceof String) {
                BigDecimal bigDecimal = new BigDecimal((String)value);
                statement.setObject(index, (Object)bigDecimal, this.id, bigDecimal.scale());
            } else {
                statement.setObject(index, value, this.id);
            }
        } else if (this.id == -102 || this.id == 91) {
            statement.setObject(index, value);
        } else {
            statement.setObject(index, value, this.id);
        }
    }

    @Override
    public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
        return statement.getObject(index);
    }
}

