/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import com.mchange.v2.c3p0.DataSources;
import java.lang.constant.Constable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.mule.db.commons.api.config.DbPoolingProfile;
import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.internal.domain.connection.enhydra.wrappers.StandardDataSourceWrapper;
import org.mule.db.commons.internal.domain.connection.enhydra.wrappers.StandardXADataSourceWrapper;
import org.mule.db.commons.internal.domain.xa.CompositeDataSourceDecorator;
import org.mule.runtime.api.config.DatabasePoolingProfile;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.tx.DataSourceDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceFactory.class);
    private final String name;
    private final Set<DataSource> pooledDataSources = ConcurrentHashMap.newKeySet();
    private final Set<Disposable> disposableDataSources = ConcurrentHashMap.newKeySet();
    private final CompositeDataSourceDecorator dataSourceDecorator;

    public DataSourceFactory(String name, Collection<DataSourceDecorator> dataSourceDecorators) {
        this.name = name;
        this.dataSourceDecorator = new CompositeDataSourceDecorator(dataSourceDecorators);
    }

    public DataSource create(DataSourceConfig dataSourceConfig, DbPoolingProfile poolingProfile) throws SQLException {
        DataSource dataSource = poolingProfile == null ? this.createSingleDataSource(dataSourceConfig) : this.createPooledDataSource(dataSourceConfig, poolingProfile);
        if (dataSourceConfig.isUseXaTransactions()) {
            dataSource = this.decorateDataSource(dataSource, poolingProfile);
        }
        if (poolingProfile != null && !dataSourceConfig.isUseXaTransactions()) {
            this.pooledDataSources.add(dataSource);
        } else if (dataSource instanceof Disposable) {
            this.disposableDataSources.add((Disposable)dataSource);
        }
        return dataSource;
    }

    public DataSource decorateDataSource(DataSource dataSource, DatabasePoolingProfile poolingProfile) {
        return this.dataSourceDecorator.decorate(dataSource, this.name, poolingProfile);
    }

    protected DataSource createSingleDataSource(DataSourceConfig dataSourceConfig) throws SQLException {
        Object dataSource = dataSourceConfig.isUseXaTransactions() ? new StandardXADataSourceWrapper(dataSourceConfig.getTlsContextFactory().orElse(null)) : new StandardDataSourceWrapper(dataSourceConfig.getTlsContextFactory().orElse(null));
        dataSource.setDriverName(dataSourceConfig.getDriverClassName());
        dataSource.setPassword(dataSourceConfig.getPassword());
        dataSource.setTransactionIsolation(dataSourceConfig.getTransactionIsolation().getCode());
        dataSource.setUrl(dataSourceConfig.getUrl());
        dataSource.setUser(dataSourceConfig.getUser());
        return dataSource;
    }

    protected DataSource createPooledDataSource(DataSourceConfig dataSourceConfig, DbPoolingProfile poolingProfile) throws SQLException {
        if (dataSourceConfig.isUseXaTransactions()) {
            return this.createSingleDataSource(dataSourceConfig);
        }
        return this.createPooledStandardDataSource(this.createSingleDataSource(dataSourceConfig), poolingProfile);
    }

    protected DataSource createPooledStandardDataSource(DataSource dataSource, DbPoolingProfile poolingProfile) throws SQLException {
        HashMap<String, Constable> config = new HashMap<String, Constable>();
        config.put("maxPoolSize", Integer.valueOf(poolingProfile.getMaxPoolSize()));
        config.put("minPoolSize", Integer.valueOf(poolingProfile.getMinPoolSize()));
        config.put("initialPoolSize", Integer.valueOf(poolingProfile.getMinPoolSize()));
        config.put("checkoutTimeout", Integer.valueOf(new Long(poolingProfile.getMaxWaitUnit().toMillis(poolingProfile.getMaxWait())).intValue()));
        config.put("acquireIncrement", Integer.valueOf(poolingProfile.getAcquireIncrement()));
        config.put("maxStatements", Integer.valueOf(poolingProfile.getMaxStatements()));
        config.put("maxIdleTime", Integer.valueOf(poolingProfile.getMaxIdleTime()));
        config.put("testConnectionOnCheckout", Boolean.valueOf(poolingProfile.getTestConnectionOnCheckout()));
        config.put("maxStatementsPerConnection", Integer.valueOf(poolingProfile.getPreparedStatementCacheSize()));
        poolingProfile.getAdditionalProperties().entrySet().forEach(param -> {
            if (config.containsKey(param.getKey()) && !config.get(param.getKey()).equals(param.getValue())) {
                LOGGER.warn(String.format("Attempted to override property %1$s using additional-properties. Proceeding to use %1$s = %2$s.", param.getKey(), param.getValue()));
            } else {
                config.put((String)param.getKey(), (Constable)param.getValue());
            }
        });
        return DataSources.pooledDataSource((DataSource)dataSource, config);
    }

    public void dispose() {
        for (DataSource pooledDataSource : this.pooledDataSources) {
            try {
                DataSources.destroy((DataSource)pooledDataSource);
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to properly release pooled data source", (Throwable)e);
            }
        }
        for (Disposable disposableDataSource : this.disposableDataSources) {
            try {
                disposableDataSource.dispose();
            }
            catch (Exception e) {
                LOGGER.warn("Unable to properly dispose data source", (Throwable)e);
            }
        }
    }
}

