/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.statement;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.io.input.ReaderInputStream;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.OutputQueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.resultset.ResultSetProcessingException;
import org.mule.db.commons.internal.result.statement.AutoGeneratedKeysProcessingException;
import org.mule.db.commons.internal.result.statement.OutputParamProcessingException;
import org.mule.db.commons.internal.result.statement.OutputParamResult;
import org.mule.db.commons.internal.result.statement.ResultSetResult;
import org.mule.db.commons.internal.result.statement.SingleStatementResult;
import org.mule.db.commons.internal.result.statement.UpdateCountResult;
import org.mule.db.commons.internal.util.InputStreamWithEOFCallbackWrapper;
import org.mule.db.commons.internal.util.ResultSetCharsetEncodedHandler;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementResultIterator
implements Iterator<SingleStatementResult> {
    public static final int NO_UPDATE_COUNT = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementResultIterator.class);
    private final Statement statement;
    private final QueryTemplate queryTemplate;
    private final AutoGenerateKeysStrategy autoGenerateKeysStrategy;
    private final DbConnection connection;
    private final ResultSetHandler resultSetHandler;
    private final int outputParamsSize;
    private Boolean cachedResult = null;
    private ResultSet resultSet;
    private int updateCount;
    private int currentOutputParam;
    private int updateCountIndex = 1;
    private int resultSetIndex = 1;
    private boolean isFirstInvocation = true;
    private ResultSet generatedKeys;
    private boolean processedGeneratedKeyResultSet;
    private boolean hasProcessedResultSet;

    public StatementResultIterator(DbConnection connection, Statement statement, QueryTemplate queryTemplate, AutoGenerateKeysStrategy autoGenerateKeysStrategy, ResultSetHandler resultSetHandler) {
        this.statement = statement;
        this.queryTemplate = queryTemplate;
        this.autoGenerateKeysStrategy = autoGenerateKeysStrategy;
        this.connection = connection;
        this.resultSetHandler = resultSetHandler;
        this.outputParamsSize = queryTemplate.getOutputParams().size();
        this.currentOutputParam = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.cachedResult != null) {
            return this.cachedResult;
        }
        try {
            if (!this.isFirstInvocation) {
                if (!this.processedGeneratedKeyResultSet) {
                    if (this.retrieveAutoGeneratedKeys()) {
                        this.generatedKeys = this.statement.getGeneratedKeys();
                        this.processedGeneratedKeyResultSet = true;
                    } else {
                        this.processedGeneratedKeyResultSet = true;
                    }
                }
                if (this.generatedKeys == null && !this.moveToNextResult() && this.statement.getUpdateCount() == -1) {
                    this.cachedResult = this.currentOutputParam < this.outputParamsSize;
                    return this.cachedResult;
                }
            } else {
                this.isFirstInvocation = false;
            }
            if (this.generatedKeys != null) {
                this.cachedResult = true;
                return true;
            }
            this.resultSet = this.statement.getResultSet();
            if (this.resultSet != null) {
                this.cachedResult = true;
                return true;
            }
            this.updateCount = this.statement.getUpdateCount();
            if (this.updateCount != -1) {
                this.cachedResult = true;
                return true;
            }
            this.cachedResult = this.currentOutputParam < this.outputParamsSize;
            return this.cachedResult;
        }
        catch (SQLException e) {
            LOGGER.warn("Unable to determine if there are more statement results", (Throwable)e);
            return false;
        }
    }

    protected boolean retrieveAutoGeneratedKeys() {
        return this.autoGenerateKeysStrategy.returnsAutoGenerateKeys();
    }

    @Override
    public SingleStatementResult next() {
        SingleStatementResult result;
        if (this.cachedResult == null) {
            this.hasNext();
        }
        this.cachedResult = null;
        if (this.resultSet != null) {
            result = this.processResultSet();
            this.hasProcessedResultSet = true;
            this.resultSet = null;
        } else if (this.updateCount != -1) {
            result = this.doProcessUpdateCount("updateCount" + this.updateCountIndex++, this.updateCount);
            this.updateCount = -1;
        } else if (this.generatedKeys != null) {
            result = this.processGeneratedKeys();
            this.generatedKeys = null;
        } else if (this.currentOutputParam < this.outputParamsSize) {
            result = this.processOutputParam();
            ++this.currentOutputParam;
        } else {
            throw new NoSuchElementException();
        }
        return result;
    }

    private SingleStatementResult processGeneratedKeys() {
        SingleStatementResult generatedKeysResult;
        try {
            generatedKeysResult = this.doProcessResultSet("generatedKeys", this.generatedKeys);
        }
        catch (SQLException e) {
            LOGGER.warn("Unable to obtain auto generated keys", (Throwable)e);
            throw new AutoGeneratedKeysProcessingException(e);
        }
        return generatedKeysResult;
    }

    private boolean moveToNextResult() throws SQLException {
        if (this.connection.getJdbcConnection().getMetaData().supportsMultipleOpenResults()) {
            return this.statement.getMoreResults(2);
        }
        if (this.hasProcessedResultSet && this.resultSetHandler.requiresMultipleOpenedResults()) {
            throw new IllegalStateException("Database does not supports streaming of resultSets on stored procedures");
        }
        return this.statement.getMoreResults();
    }

    protected SingleStatementResult processOutputParam() {
        OutputQueryParam outputSqlParam = this.queryTemplate.getOutputParams().get(this.currentOutputParam);
        try {
            Object paramValue = outputSqlParam.getType().getParameterValue((CallableStatement)this.statement, outputSqlParam.getIndex());
            return this.doProcessOutputParam(outputSqlParam, paramValue);
        }
        catch (SQLException e) {
            LOGGER.warn("Unable to obtain output parameter", (Throwable)e);
            throw new OutputParamProcessingException(e);
        }
    }

    protected SingleStatementResult doProcessOutputParam(OutputQueryParam outputSqlParam, Object paramValue) throws SQLException {
        paramValue = paramValue instanceof ResultSet ? this.resultSetHandler.processResultSet(this.connection, (ResultSet)paramValue) : this.processValue(paramValue);
        return new OutputParamResult(outputSqlParam.getName(), paramValue);
    }

    private Object processValue(Object paramValue) throws SQLException {
        if (null == paramValue) {
            return paramValue;
        }
        if (paramValue instanceof Struct) {
            Object[] objects = ((Struct)paramValue).getAttributes();
            return this.processValueArray(objects);
        }
        if (paramValue instanceof SQLXML) {
            return ((SQLXML)paramValue).getString();
        }
        if (paramValue instanceof Collection) {
            Object[] collectionValue = ((Collection)paramValue).toArray(new Object[0]);
            return this.processValueArray(collectionValue);
        }
        if (paramValue instanceof Array) {
            Object objArray = ((Array)paramValue).getArray();
            if (objArray.getClass().isArray()) {
                Object[] collectionValue = (Object[])((Array)paramValue).getArray();
                return this.processValueArray(collectionValue);
            }
            return objArray;
        }
        if (paramValue.getClass().isArray()) {
            Object[] collectionValue = (Object[])paramValue;
            return this.processValueArray(collectionValue);
        }
        if (paramValue instanceof Clob) {
            return this.handleClobType((Clob)paramValue);
        }
        return paramValue;
    }

    private Object[] processValueArray(Object[] paramValues) throws SQLException {
        Object[] newArrayValue = new Object[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            Object value = paramValues[i];
            newArrayValue[i] = this.processValue(value);
        }
        return newArrayValue;
    }

    protected SingleStatementResult doProcessUpdateCount(String name, int value) {
        return new UpdateCountResult(name, value);
    }

    private SingleStatementResult processResultSet() {
        SingleStatementResult result;
        String name = "resultSet" + this.resultSetIndex++;
        try {
            result = this.doProcessResultSet(name, this.resultSet);
        }
        catch (SQLException e) {
            LOGGER.warn("Unable to obtain next resultSet", (Throwable)e);
            throw new ResultSetProcessingException("Error processing result set: " + name, e);
        }
        return result;
    }

    protected SingleStatementResult doProcessResultSet(String name, ResultSet resultSet) throws SQLException {
        Object handledResultSet = this.resultSetHandler.processResultSet(this.connection, resultSet);
        return new ResultSetResult(name, handledResultSet);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private TypedValue<Object> handleClobType(Clob value) throws SQLException {
        Charset charset = this.getCharset(this.resultSetHandler);
        ReaderInputStream inputStream = new ReaderInputStream(value.getCharacterStream(), charset);
        if (this.connection != null && this.connection.supportsContentStreaming()) {
            this.connection.beginStreaming();
            InputStreamWithEOFCallbackWrapper inputStreamWrapper = new InputStreamWithEOFCallbackWrapper((InputStream)inputStream, () -> {
                this.connection.endStreaming();
                this.connection.release();
            });
            return new TypedValue((Object)inputStreamWrapper, DataType.builder().type(InputStream.class).mediaType(MediaType.TEXT).charset(charset).build());
        }
        return new TypedValue((Object)new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream)), DataType.builder().type(byte[].class).mediaType(MediaType.TEXT).charset(charset).build());
    }

    private Charset getCharset(ResultSetHandler resultSetHandler) {
        if (resultSetHandler instanceof ResultSetCharsetEncodedHandler) {
            return ((ResultSetCharsetEncodedHandler)resultSetHandler).getCharset();
        }
        return Charset.defaultCharset();
    }
}

