/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.query;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.param.OutputParameter;
import org.mule.db.commons.api.param.ParameterType;
import org.mule.db.commons.api.param.StoredProcedureCall;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.DefaultInOutQueryParam;
import org.mule.db.commons.internal.domain.param.DefaultInputQueryParam;
import org.mule.db.commons.internal.domain.param.DefaultOutputQueryParam;
import org.mule.db.commons.internal.domain.param.QueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.DynamicDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbTypeException;
import org.mule.db.commons.internal.resolver.query.ParameterizedQueryResolver;
import org.mule.runtime.api.util.Reference;

public class StoredProcedureQueryResolver
extends ParameterizedQueryResolver<StoredProcedureCall> {
    @Override
    protected QueryTemplate createQueryTemplate(StoredProcedureCall call, AbstractDbConnector connector, DbConnection connection) {
        QueryTemplate queryTemplate = super.createQueryTemplate(call, connector, connection);
        return new QueryTemplate(queryTemplate.getSqlText(), queryTemplate.getType(), this.resolveParamTypes(queryTemplate, call, connector, connection), queryTemplate.isDynamic());
    }

    private List<QueryParam> resolveParamTypes(QueryTemplate queryTemplate, StoredProcedureCall call, AbstractDbConnector connector, DbConnection connection) {
        DbTypeManager typeManager = this.createTypeManager(connector, connection);
        return queryTemplate.getParams().stream().map(param -> {
            String paramName = param.getName();
            Optional<OutputParameter> outputParameter = call.getOutputParameter(paramName);
            if (outputParameter.isPresent()) {
                ParameterType parameterType = outputParameter.get();
                DbType type = parameterType.getDbType() != null ? parameterType.getDbType() : param.getType();
                try {
                    if (type instanceof DynamicDbType) {
                        type = typeManager.lookup(connection, type.getName());
                    }
                }
                catch (UnknownDbTypeException e) {
                    type = param.getType();
                }
                return new DefaultOutputQueryParam(param.getIndex(), type, paramName);
            }
            Optional<Reference<Object>> parameterValue = call.getInputParameter(paramName);
            if (parameterValue.isPresent()) {
                return new DefaultInputQueryParam(param.getIndex(), param.getType(), parameterValue.get().get(), paramName);
            }
            parameterValue = call.getInOutParameter(paramName);
            if (parameterValue.isPresent()) {
                return new DefaultInOutQueryParam(param.getIndex(), param.getType(), paramName, parameterValue.get().get());
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' was not bound for query '%s'", paramName, call.getSql()));
        }).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    protected Optional<Reference<Object>> getInputParameter(StoredProcedureCall statementDefinition, String parameterName) {
        Optional<Reference<Object>> value = super.getInputParameter(statementDefinition, parameterName);
        if (!value.isPresent()) {
            value = statementDefinition.getInOutParameter(parameterName);
        }
        return value;
    }
}

