/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClobResolvedDataType
extends ResolvedDbType {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClobResolvedDataType.class);
    private static final String JTDS_DRIVER = "jTDS";

    public ClobResolvedDataType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        if (value != null && !(value instanceof Clob)) {
            try {
                LOGGER.debug("Creating CLOB object");
                if (value instanceof String) {
                    this.handleIfString(statement, index, value, connection);
                }
                if (value instanceof ByteArrayInputStream) {
                    this.handleIfByteArrayInputStream(statement, index, value, connection);
                }
                this.handleIfInputStreamOrFail(statement, index, value, connection);
            }
            catch (SQLException sqlException) {
                LOGGER.debug("Error creating CLOB object. Using alternative way to set CLOB object.", (Throwable)sqlException);
                this.handlePriorVersions(statement, index, value);
            }
            catch (IOException ioException) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Cannot consume content of CLOB from a value of type '%s'", (Object[])new Object[]{value.getClass()}), (Throwable)ioException);
            }
        } else {
            super.setParameterValue(statement, index, value, connection);
        }
    }

    private void handleIfString(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        Clob clob = statement.getConnection().createClob();
        clob.setString(1L, (String)value);
        super.setParameterValue(statement, index, clob, connection);
    }

    private void handleIfByteArrayInputStream(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException, IOException {
        Clob clob = statement.getConnection().createClob();
        OutputStream outputStream = clob.setAsciiStream(1L);
        outputStream.write(IOUtils.toByteArray((InputStream)((InputStream)value)));
        outputStream.flush();
        outputStream.close();
        super.setParameterValue(statement, index, clob, connection);
    }

    private void handleIfInputStreamOrFail(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException, IOException {
        InputStreamReader reader;
        if (value instanceof InputStream) {
            reader = new InputStreamReader((InputStream)value);
        } else if (value instanceof TypedValue && ((TypedValue)value).getValue() instanceof InputStream) {
            reader = new InputStreamReader((InputStream)((TypedValue)value).getValue());
        } else {
            throw new IllegalArgumentException(String.format("Cannot create a CLOB from a value of type '%s'", value.getClass()));
        }
        Clob clob = statement.getConnection().createClob();
        Writer writer = clob.setCharacterStream(1L);
        IOUtils.copyLarge((Reader)reader, (Writer)writer);
        writer.flush();
        writer.close();
        super.setParameterValue(statement, index, clob, connection);
    }

    private void handlePriorVersions(PreparedStatement statement, int index, Object value) throws SQLException {
        String valueString;
        DatabaseMetaData metaData = statement.getConnection().getMetaData();
        if (value instanceof String) {
            valueString = (String)value;
        } else if (value instanceof InputStream) {
            valueString = IOUtils.toString((InputStream)((InputStream)value));
        } else {
            throw new IllegalArgumentException(String.format("Cannot create a CLOB from a value of type '%s'", value.getClass()));
        }
        if (metaData != null && metaData.getDriverName() != null && metaData.getDriverName().contains(JTDS_DRIVER)) {
            statement.setString(index, valueString);
        } else {
            statement.setCharacterStream(index, (Reader)new StringReader(valueString), valueString.length());
        }
    }
}

