/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.param;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.db.commons.api.param.ParameterType;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.QueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbTypeException;
import org.mule.db.commons.internal.resolver.param.ParamTypeResolver;
import org.mule.db.commons.internal.util.StoredProcedureUtils;
import org.mule.runtime.api.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredProcedureParamTypeResolver
implements ParamTypeResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoredProcedureParamTypeResolver.class);
    public static final String FORCE_SP_PARAM_TYPES = "mule.db.connector.force.sp.param.types";
    private static final int PARAM_NAME_COLUMN_INDEX = 4;
    private static final int TYPE_ID_COLUMN_INDEX = 6;
    private static final int TYPE_NAME_COLUMN_INDEX = 7;
    private static final int COLUMN_TYPE_INDEX = 5;
    private static final short PROCEDURE_COLUMN_RETURN_COLUMN_TYPE = 5;
    private final DbTypeManager dbTypeManager;

    public StoredProcedureParamTypeResolver(DbTypeManager dbTypeManager) {
        this.dbTypeManager = dbTypeManager;
    }

    @Override
    public Map<Integer, DbType> getParameterTypes(DbConnection connection, QueryTemplate queryTemplate, List<ParameterType> parameterTypesConfigured) throws SQLException {
        Map<Integer, DbType> parameters;
        if (this.shouldForceParametersTypes()) {
            parameters = this.getParameterTypesFromConfiguration(queryTemplate, parameterTypesConfigured);
            List<String> missingParameters = this.getMissingParameters(queryTemplate, parameters);
            if (missingParameters.isEmpty()) {
                return parameters;
            }
            LOGGER.warn("Could not find query parameters {} using configured types.", (Object)String.join((CharSequence)", ", missingParameters));
        }
        LOGGER.debug("Getting Stored Procedure parameters types using DB metadata");
        parameters = this.getStoredProcedureParamTypesUsingMetadataAndValidate(connection, queryTemplate);
        return parameters;
    }

    private Map<Integer, DbType> getStoredProcedureParamTypesUsingMetadataAndValidate(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        Map<Integer, DbType> parameters = this.getStoredProcedureParamTypesUsingMetadata(connection, queryTemplate);
        List<String> missingParameters = this.getMissingParameters(queryTemplate, parameters);
        if (!missingParameters.isEmpty()) {
            throw new SQLException(String.format("Could not find query parameters %s.", String.join((CharSequence)",", missingParameters)));
        }
        return parameters;
    }

    private Map<Integer, DbType> getStoredProcedureParamTypesUsingMetadata(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getJdbcConnection().getMetaData();
        Pair<String, Boolean> storedOperationResult = StoredProcedureUtils.analyzeStoredOperation(queryTemplate.getSqlText());
        String storedProcedureName = (String)storedOperationResult.getFirst();
        String storedProcedureOwner = StoredProcedureUtils.getStoreProcedureOwner(queryTemplate.getSqlText()).orElse(null);
        String storedProcedureParentOwner = StoredProcedureUtils.getStoredProcedureParentOwner(queryTemplate.getSqlText()).orElse(null);
        if (dbMetaData.storesUpperCaseIdentifiers()) {
            storedProcedureName = storedProcedureName.toUpperCase();
            if (storedProcedureOwner != null) {
                storedProcedureOwner = storedProcedureOwner.toUpperCase();
            }
            if (storedProcedureParentOwner != null) {
                storedProcedureParentOwner = storedProcedureParentOwner.toUpperCase();
            }
        }
        try (ResultSet procedureColumns = connection.getProcedureColumns(storedProcedureName, storedProcedureOwner, storedProcedureParentOwner, connection.getJdbcConnection().getCatalog());){
            Map<Integer, DbType> map = this.getStoredProcedureParamTypes(connection, storedProcedureName, procedureColumns, (Boolean)storedOperationResult.getSecond());
            return map;
        }
    }

    private Map<Integer, DbType> getStoredProcedureParamTypes(DbConnection connection, String storedProcedureName, ResultSet procedureColumns, boolean isFunction) throws SQLException {
        HashMap<Integer, DbType> paramTypes = new HashMap<Integer, DbType>();
        int position = 1;
        while (procedureColumns.next()) {
            DbType dbType;
            if (!isFunction && procedureColumns.getShort(5) == 5) continue;
            int typeId = procedureColumns.getInt(6);
            String typeName = procedureColumns.getString(7);
            String parameterName = procedureColumns.getString(4);
            LOGGER.debug("Resolved parameter type: Store procedure: {}, Name: {}, Index: {}, Type ID: {}, Type Name: {}", new Object[]{storedProcedureName, parameterName, position, typeId, typeName});
            try {
                Optional<DbType> vendorDbType = connection.getDbTypeByVendor(typeName, procedureColumns);
                dbType = vendorDbType.orElse(this.dbTypeManager.lookup(connection, typeId, typeName));
            }
            catch (UnknownDbTypeException e) {
                dbType = new ResolvedDbType(typeId, typeName);
            }
            paramTypes.put(position, dbType);
            ++position;
        }
        return paramTypes;
    }

    private List<String> getMissingParameters(QueryTemplate queryTemplate, Map<Integer, DbType> paramTypes) {
        return queryTemplate.getParams().stream().filter(queryParam -> !paramTypes.containsKey(queryParam.getIndex())).map(QueryParam::getName).collect(Collectors.toList());
    }

    private boolean shouldForceParametersTypes() {
        return Boolean.parseBoolean(System.getProperty(FORCE_SP_PARAM_TYPES, "false"));
    }

    private Map<Integer, DbType> getParameterTypesFromConfiguration(QueryTemplate queryTemplate, List<ParameterType> parameterTypesConfigured) {
        HashMap<Integer, DbType> paramTypes = new HashMap<Integer, DbType>();
        for (QueryParam queryParam : queryTemplate.getParams()) {
            Optional<ParameterType> type = parameterTypesConfigured.stream().filter(p -> p.getKey().equals(queryParam.getName())).findAny();
            if (!type.isPresent()) continue;
            String parameterTypeName = type.get().getDbType().getName();
            DbType dbType = parameterTypeName == null ? UnknownDbType.getInstance() : type.get().getDbType();
            paramTypes.put(queryParam.getIndex(), dbType);
        }
        return paramTypes;
    }
}

