/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.mule.db.commons.api.exception.connection.DbError;
import org.mule.db.commons.internal.result.row.RowHandler;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetIterator
implements Iterator<Map<String, Object>> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ResultSetIterator.class);
    private final ResultSet resultSet;
    private final RowHandler rowHandler;
    private Boolean cachedNext = null;

    public ResultSetIterator(ResultSet resultSet, RowHandler rowHandler) {
        this.resultSet = resultSet;
        this.rowHandler = rowHandler;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.cachedNext == null) {
            try {
                this.cachedNext = this.resultSet.next();
                result = this.cachedNext;
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to determine if there are more records", (Throwable)e);
            }
        } else {
            result = this.cachedNext;
        }
        return result;
    }

    @Override
    public Map<String, Object> next() {
        try {
            if (this.cachedNext == null) {
                this.resultSet.next();
            } else {
                this.cachedNext = null;
            }
            return this.rowHandler.process(this.resultSet);
        }
        catch (SQLException e) {
            LOGGER.warn("Unable to obtain next row", (Throwable)e);
            throw new ModuleException("Unable to obtain next row", (ErrorTypeDefinition)DbError.CONNECTIVITY, (Throwable)e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

