/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.sql.SQLException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StoredProcedureUtils {
    private static final String STORED_PROCEDURE_REGEX = "(?msi)(\\{\\s*)?call\\s+(\\w+\\.)?(\\w+\\.)?(\\w+)\\s*\\(.*";
    private static final Pattern storedProcedurePattern = Pattern.compile("(?msi)(\\{\\s*)?call\\s+(\\w+\\.)?(\\w+\\.)?(\\w+)\\s*\\(.*");

    public static String getStoredProcedureName(String sqlText) throws SQLException {
        Matcher matcher = storedProcedurePattern.matcher(sqlText);
        if (!matcher.matches()) {
            throw new SQLException(String.format("Unable to detect stored procedure name from '%s'", sqlText));
        }
        return matcher.group(4);
    }

    public static Optional<String> getStoreProcedureOwner(String sqlText) throws SQLException {
        Matcher matcher = storedProcedurePattern.matcher(sqlText);
        if (!matcher.matches()) {
            throw new SQLException(String.format("Unable to detect stored procedure schema from '%s'", sqlText));
        }
        String firstPart = matcher.group(2);
        String secondPart = matcher.group(3);
        if (!StringUtils.isBlank((CharSequence)firstPart) && !StringUtils.isBlank((CharSequence)secondPart)) {
            String packageName = firstPart.substring(0, firstPart.length() - 1);
            return Optional.of(packageName);
        }
        if (!StringUtils.isBlank((CharSequence)firstPart)) {
            String packageName = firstPart.substring(0, firstPart.length() - 1);
            return Optional.of(packageName);
        }
        if (!StringUtils.isBlank((CharSequence)secondPart)) {
            String packageName = secondPart.substring(0, secondPart.length() - 1);
            return Optional.of(packageName);
        }
        return Optional.empty();
    }

    public static Optional<String> getStoredProcedureParentOwner(String sqlText) throws SQLException {
        Matcher matcher = storedProcedurePattern.matcher(sqlText);
        if (!matcher.matches()) {
            throw new SQLException(String.format("Unable to detect stored procedure package from '%s'", sqlText));
        }
        String firstPart = matcher.group(2);
        String secondPart = matcher.group(3);
        if (!StringUtils.isBlank((CharSequence)firstPart) && !StringUtils.isBlank((CharSequence)secondPart)) {
            String packageName = secondPart.substring(0, secondPart.length() - 1);
            return Optional.of(packageName);
        }
        return Optional.empty();
    }
}

