/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.metadata;

import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.parser.SimpleQueryTemplateParser;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.util.LazyValue;

public abstract class BaseDbMetadataResolver {
    protected BaseTypeBuilder typeBuilder;
    protected ClassTypeLoader typeLoader;
    private final LazyValue<Map<Integer, MetadataType>> dbToMetaDataType = new LazyValue(this::initializeDbToMetaDataType);

    protected QueryTemplate parseQuery(String query) {
        return new SimpleQueryTemplateParser().parse(query);
    }

    protected PreparedStatement getStatement(MetadataContext context, QueryTemplate query) throws ConnectionException, MetadataResolvingException {
        PreparedStatement statement;
        DbConnection connection = (DbConnection)context.getConnection().orElseThrow(() -> new MetadataResolvingException("A connection is required to resolve Metadata but none was provided", FailureCode.INVALID_CONFIGURATION));
        try {
            statement = connection.getJdbcConnection().prepareStatement(query.getSqlText());
        }
        catch (SQLException e) {
            throw new MetadataResolvingException(e.getMessage(), FailureCode.UNKNOWN, (Throwable)e);
        }
        return statement;
    }

    protected MetadataType getDataTypeMetadataModel(int typeId, String columnClassName) {
        if (typeId == 2000) {
            return (MetadataType)this.typeLoader.load(columnClassName).orElse(this.typeBuilder.anyType().build());
        }
        if (typeId == 2002) {
            try {
                if (Struct.class.isAssignableFrom(Class.forName(columnClassName))) {
                    ArrayTypeBuilder arrayTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType();
                    arrayTypeBuilder.of().anyType();
                    return arrayTypeBuilder.build();
                }
                return (MetadataType)this.typeLoader.load(columnClassName).orElse(this.typeBuilder.anyType().build());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.getDataTypeMetadataModel(typeId);
    }

    protected MetadataType getDataTypeMetadataModel(int columnTypeName) {
        return (MetadataType)((Map)this.dbToMetaDataType.get()).getOrDefault(columnTypeName, this.typeBuilder.anyType().build());
    }

    private Map<Integer, MetadataType> initializeDbToMetaDataType() {
        HashMap<Integer, MetadataType> initialDbToMetaDataType = new HashMap<Integer, MetadataType>();
        NumberType numberType = this.typeBuilder.numberType().build();
        DefaultStringType stringType = this.typeBuilder.stringType().build();
        BinaryType binaryType = this.typeBuilder.binaryType().build();
        AnyType anyType = this.typeBuilder.anyType().build();
        initialDbToMetaDataType.put(-7, (MetadataType)this.typeBuilder.booleanType().build());
        initialDbToMetaDataType.put(16, (MetadataType)this.typeBuilder.booleanType().build());
        initialDbToMetaDataType.put(-6, (MetadataType)numberType);
        initialDbToMetaDataType.put(5, (MetadataType)numberType);
        initialDbToMetaDataType.put(4, (MetadataType)numberType);
        initialDbToMetaDataType.put(-5, (MetadataType)numberType);
        initialDbToMetaDataType.put(6, (MetadataType)numberType);
        initialDbToMetaDataType.put(7, (MetadataType)numberType);
        initialDbToMetaDataType.put(8, (MetadataType)numberType);
        initialDbToMetaDataType.put(2, (MetadataType)numberType);
        initialDbToMetaDataType.put(3, (MetadataType)numberType);
        initialDbToMetaDataType.put(1, (MetadataType)stringType);
        initialDbToMetaDataType.put(12, (MetadataType)stringType);
        initialDbToMetaDataType.put(-16, (MetadataType)stringType);
        initialDbToMetaDataType.put(2005, (MetadataType)stringType);
        initialDbToMetaDataType.put(-15, (MetadataType)stringType);
        initialDbToMetaDataType.put(-9, (MetadataType)stringType);
        initialDbToMetaDataType.put(2011, (MetadataType)stringType);
        initialDbToMetaDataType.put(-2, (MetadataType)binaryType);
        initialDbToMetaDataType.put(-3, (MetadataType)binaryType);
        initialDbToMetaDataType.put(-4, (MetadataType)binaryType);
        initialDbToMetaDataType.put(2004, (MetadataType)binaryType);
        initialDbToMetaDataType.put(91, (MetadataType)this.typeBuilder.dateType().build());
        initialDbToMetaDataType.put(93, (MetadataType)this.typeBuilder.dateType().build());
        initialDbToMetaDataType.put(92, (MetadataType)this.typeBuilder.timeType().build());
        initialDbToMetaDataType.put(1111, (MetadataType)this.typeBuilder.anyType().build());
        initialDbToMetaDataType.put(2000, (MetadataType)this.typeBuilder.anyType().build());
        initialDbToMetaDataType.put(2001, (MetadataType)this.typeBuilder.anyType().build());
        initialDbToMetaDataType.put(2003, (MetadataType)this.typeBuilder.arrayType().of((MetadataType)anyType).build());
        initialDbToMetaDataType.put(0, (MetadataType)this.typeBuilder.nullType().build());
        initialDbToMetaDataType.put(2009, (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType().build());
        initialDbToMetaDataType.put(2002, (MetadataType)this.typeBuilder.arrayType().of((MetadataType)anyType).build());
        initialDbToMetaDataType.put(2006, this.typeLoader.load(Ref.class));
        initialDbToMetaDataType.put(70, this.typeLoader.load(URL.class));
        initialDbToMetaDataType.put(-8, this.typeLoader.load(RowId.class));
        return initialDbToMetaDataType;
    }
}

