/*
 * Decompiled with CFR 0.152.
 */
package org.mule.oauth.client.internal.builder;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.oauth.client.api.http.HttpClientFactory;
import org.mule.oauth.client.api.listener.ClientCredentialsListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.oauth.client.internal.DefaultClientCredentialsOAuthDancer;
import org.mule.oauth.client.internal.builder.AbstractOAuthDancerBuilder;
import org.mule.oauth.client.internal.config.AuthDancerCredentialConfig;
import org.mule.oauth.client.internal.config.DefaultClientCredentialsOAuthDancerConfig;
import org.mule.oauth.client.internal.config.TokenParserConfig;
import org.mule.oauth.client.internal.util.MultiMapUtils;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;

public class DefaultOAuthClientCredentialsDancerBuilder
extends AbstractOAuthDancerBuilder<ClientCredentialsOAuthDancer>
implements OAuthClientCredentialsDancerBuilder {
    private final List<ClientCredentialsListener> listeners = new LinkedList<ClientCredentialsListener>();
    private final MultiMap<String, String> customParameters = new MultiMap();
    private final MultiMap<String, String> customHeaders = new MultiMap();
    private final Map<String, String> customBodyParameters = new LinkedHashMap<String, String>();

    public DefaultOAuthClientCredentialsDancerBuilder(SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClientFactory httpClientFactory, MuleExpressionLanguage expressionEvaluator) {
        super(schedulerService, lockProvider, tokensStore, httpClientFactory, expressionEvaluator);
    }

    @Deprecated(since="1.0")
    public OAuthClientCredentialsDancerBuilder encodeClientCredentialsInBody(boolean encodeClientCredentialsInBody) {
        return (OAuthClientCredentialsDancerBuilder)super.encodeClientCredentialsInBody(encodeClientCredentialsInBody);
    }

    public OAuthClientCredentialsDancerBuilder customParameters(Map<String, String> customParameters) {
        Objects.requireNonNull(customParameters, "customParameters cannot be null");
        MultiMapUtils.putAll(customParameters, this.customParameters);
        return this;
    }

    public OAuthClientCredentialsDancerBuilder customHeaders(Map<String, String> customHeaders) {
        Objects.requireNonNull(customHeaders, "customHeaders cannot be null");
        MultiMapUtils.putAll(customHeaders, this.customHeaders);
        return this;
    }

    public OAuthClientCredentialsDancerBuilder customBodyParameters(Map<String, String> customBodyParameters) {
        Objects.requireNonNull(customBodyParameters, "customBodyParameters cannot be null");
        this.customBodyParameters.putAll(customBodyParameters);
        return this;
    }

    public OAuthClientCredentialsDancerBuilder addListener(ClientCredentialsListener listener) {
        Objects.requireNonNull(listener, "Cannot add a null listener");
        this.listeners.add(listener);
        return this;
    }

    public ClientCredentialsOAuthDancer build() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"clientId cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (String)"clientSecret cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tokenUrl), (String)"tokenUrl cannot be blank");
        DefaultClientCredentialsOAuthDancerConfig config = new DefaultClientCredentialsOAuthDancerConfig();
        config.setName(this.name);
        config.setCredentialConfig(AuthDancerCredentialConfig.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withClientCredentialsLocation(this.clientCredentialsLocation).build());
        config.setTokenUrl(this.tokenUrl);
        config.setScopes(this.scopes);
        config.setEncoding(this.encoding);
        config.setTokenParserConfig(TokenParserConfig.builder().withResponseAccessTokenExpr(this.responseAccessTokenExpr).withResponseRefreshTokenExpr(this.responseRefreshTokenExpr).withResponseExpiresInExpr(this.responseExpiresInExpr).build());
        config.setCustomParametersExtractorsExprs(this.customParametersExtractorsExprs);
        config.setResourceOwnerIdTransformer(this.resourceOwnerIdTransformer);
        config.setSchedulerService(this.schedulerService);
        config.setLockProvider(this.lockProvider);
        config.setTokensStore(this.tokensStore);
        config.setHttpClient((HttpClient)this.httpClientFactory.get());
        config.setExpressionEvaluator(this.expressionEvaluator);
        config.setCustomParameters(this.customParameters);
        config.setCustomHeaders(this.customHeaders);
        config.setCustomBodyParameters(this.customBodyParameters);
        config.setListeners(this.listeners);
        return new DefaultClientCredentialsOAuthDancer(config);
    }
}

