/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.oauth.client.internal.config;

import org.mule.oauth.client.api.builder.ClientCredentialsLocation;

/**
 * A set of common attributes to all grant-types dancer credential.
 *
 * @since 1.0
 */
public class AuthDancerCredentialConfig {

  private String clientId;
  private String clientSecret;
  private ClientCredentialsLocation clientCredentialsLocation;

  public AuthDancerCredentialConfig(String clientId, String clientSecret, ClientCredentialsLocation clientCredentialsLocation) {
    this.clientId = clientId;
    this.clientSecret = clientSecret;
    this.clientCredentialsLocation = clientCredentialsLocation;
  }

  public String getClientId() {
    return clientId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  public String getClientSecret() {
    return clientSecret;
  }

  public void setClientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
  }

  public ClientCredentialsLocation getClientCredentialsLocation() {
    return clientCredentialsLocation;
  }

  public void setClientCredentialsLocation(ClientCredentialsLocation clientCredentialsLocation) {
    this.clientCredentialsLocation = clientCredentialsLocation;
  }

  public static Builder builder() {
    return new Builder();
  }

  /**
   * Builder implementation for creating a {@link TokenParserConfig} instance
   *
   * @since 1.0
   */
  public static class Builder {

    private String clientId;
    private String clientSecret;
    private ClientCredentialsLocation clientCredentialsLocation;

    private Builder() {}

    public Builder withClientId(String clientId) {
      this.clientId = clientId;
      return this;
    }

    public Builder withClientSecret(String clientSecret) {
      this.clientSecret = clientSecret;
      return this;
    }

    public Builder withClientCredentialsLocation(ClientCredentialsLocation clientCredentialsLocation) {
      this.clientCredentialsLocation = clientCredentialsLocation;
      return this;
    }

    public AuthDancerCredentialConfig build() {
      return new AuthDancerCredentialConfig(clientId, clientSecret, clientCredentialsLocation);
    }
  }
}
