/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * Provides OAuth authentication client.
 *
 * @moduleGraph
 * @since 2.0
 */
module org.mule.oauth.client.impl {

  requires org.mule.runtime.api;
  requires transitive org.mule.runtime.http.api;
  requires org.mule.oauth.client.api;
  
  requires com.github.benmanes.caffeine;
  requires org.apache.commons.codec;
  requires org.apache.commons.io;
  requires org.apache.commons.lang3;

  exports org.mule.oauth.client.api.http;
  
  exports org.mule.oauth.client.internal to
      com.mulesoft.mule.service.oauth.ee;
  exports org.mule.oauth.client.internal.state to
      com.mulesoft.mule.service.oauth.ee;
  exports org.mule.oauth.client.internal.builder to
      org.mule.service.oauth,
      com.mulesoft.mule.service.oauth.ee;
  exports org.mule.oauth.client.internal.config to
      com.mulesoft.mule.service.oauth.ee;
  
}
