package org.mule.commons.atlantic.lambda.consumer;

import org.mule.commons.atlantic.lambda.function.TriFunction;

/**
 * Represents an operation that accepts three input arguments and returns no result.  This is the three-arity
 * specialization of {@link Consumer}.
 * Unlike most other functional interfaces, {@code TriConsumer} is expected to operate via side-effects.
 *
 * This is a functional interface whose functional method is {@link #accept(Object, Object, Object)}.
 *
 * @param <A> The type of the first argument to the operation.
 * @param <B> The type of the second argument to the operation.
 * @param <C> The type of the third argument to the operation.
 */
@FunctionalInterface
public interface TriConsumer<A, B, C> extends AtlanticConsumer<TriFunction<A, B, C, Void>> {

    /**
     * Performs this operation on the given arguments.
     *
     * @param a The first input argument.
     * @param b The second input argument.
     * @param c The third input argument.
     * @throws Throwable Any exception that the operation will throw.
     */
    void accept(A a, B b, C c) throws Throwable;

    @Override
    default TriFunction<A, B, C, Void> toFunction() {
        return (a, b, c) -> {
            accept(a, b, c);
            return null;
        };
    }
}
