package org.mule.commons.atlantic.lambda.consumer;

import org.mule.commons.atlantic.lambda.function.OctaFunction;

/**
 * Represents an operation that accepts eight input arguments and returns no result.  This is the eight-arity
 * specialization of {@link Consumer}.
 * Unlike most other functional interfaces, {@code OctaConsumer} is expected to operate via side-effects.
 *
 * This is a functional interface whose functional method is {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object)}.
 *
 * @param <A> The type of the first argument to the operation.
 * @param <B> The type of the second argument to the operation.
 * @param <C> The type of the third argument to the operation.
 * @param <D> The type of the fourth argument to the operation.
 * @param <E> The type of the fifth argument to the operation.
 * @param <F> The type of the sixth argument to the operation.
 * @param <G> The type of the seventh argument to the operation.
 * @param <H> The type of the eighth argument to the operation.
 */
@FunctionalInterface
public interface OctaConsumer<A, B, C, D, E, F, G, H> extends AtlanticConsumer<OctaFunction<A, B, C, D, E, F, G, H, Void>> {

    /**
     * Performs this operation on the given arguments.
     *
     * @param a The first input argument.
     * @param b The second input argument.
     * @param c The third input argument.
     * @param d The fourth input argument.
     * @param e The fifth input argument.
     * @param f The sixth input argument.
     * @param g The seventh input argument.
     * @param h The eighth input argument.
     * @throws Throwable Any exception that the operation will throw.
     */
    void accept(A a, B b, C c, D d, E e, F f, G g, H h) throws Throwable;

    @Override
    default OctaFunction<A, B, C, D, E, F, G, H, Void> toFunction() {
        return (a, b, c, d, e, f, g, h) -> {
            accept(a, b, c, d, e, f, g, h);
            return null;
        };
    }
}
