package org.mule.commons.atlantic.lambda.consumer;

import org.mule.commons.atlantic.lambda.function.Function;

/**
 * Represents an operation that accepts a single input argument and returns no result. Unlike most other functional
 * interfaces, {@code Consumer} is expected to operate via side-effects.
 *
 * This is a functional interface whose functional method is {@link #accept(Object)}.
 *
 * @param <A> The type of the input to the operation.
 */
@FunctionalInterface
public interface Consumer<A> extends AtlanticConsumer<Function<A, Void>> {

    /**
     * Performs this operation on the given argument.
     *
     * @param parameter The input argument.
     * @throws Throwable Any exception that the operation will throw.
     */
    void accept(A parameter) throws Throwable;

    @Override
    default Function<A, Void> toFunction() {
        return (a) -> {
            accept(a);
            return null;
        };
    }
}
