package org.mule.commons.atlantic.execution.context.listener;

import java.util.List;

/**
 * Listener that executes after the operation is executed.
 *
 * @param <RESULT> The type of result returned by the execution.
 */
public interface PostExecutionListener<RESULT> {

    /**
     * Method called after the operation is executed.
     *
     * @param params         The parameters of the operation. For instance methods, the first parameter is the instance
     *                       executing the method.
     * @param returnedObject The result of the {@link org.mule.commons.atlantic.lambda.AtlanticLambda} call.
     */
    void onPostExecute(List<Object> params, RESULT returnedObject);
}
