package org.mule.commons.atlantic.execution.context.exception;

/**
 * Specific implementation of {@link DefinedExceptionHandler} that lets the exception (which must be a subclass of the
 * {@link RuntimeException} class) pass through. All exceptions that extend the defined class will be ignored too.
 *
 * @param <T> The type of {@link RuntimeException} that will be ignored.
 */
public final class PassThroughExceptionHandler<T extends RuntimeException> extends DefinedExceptionHandler<T> {

    /**
     * Default constructor. Sets the ignored exception type.
     *
     * @param handledException The exception to ignore. The children of this class will be ignored too.
     */
    public PassThroughExceptionHandler(Class<T> handledException) {
        super(handledException, runtimeException -> {
            throw runtimeException;
        });
    }
}
