package org.mule.commons.atlantic.exception;

import java.util.Optional;

import static java.lang.String.format;

/**
 * Exception thrown when an uncaught exception is thrown while parsing an object using a
 * {@link org.mule.commons.atlantic.execution.parser.Parser}.
 */
public class ConversionException extends AtlanticException {

    /**
     * Default constructor.
     *
     * @param from  The object to parse.
     * @param cause The root cause.
     */
    public ConversionException(Object from, Throwable cause) {
        super(format("An exception occurred while converting from %s.",
                Optional.ofNullable(from).orElse("an empty value")), cause);
    }
}
