/*
 * Decompiled with CFR 0.152.
 */
package org.mule.commons.atlantic.execution.context.executor;

import java.util.List;
import org.mule.commons.atlantic.exception.UnhandledException;
import org.mule.commons.atlantic.execution.context.exception.DefinedExceptionHandler;
import org.mule.commons.atlantic.execution.context.executor.Executor;
import org.mule.commons.atlantic.execution.context.listener.PostExecutionListener;
import org.mule.commons.atlantic.execution.context.listener.PreExecutionListener;
import org.mule.commons.atlantic.lambda.supplier.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingExecutor<RESULT>
implements Executor<RESULT> {
    private static final Logger logger = LoggerFactory.getLogger(BlockingExecutor.class);

    @Override
    public RESULT execute(Supplier<RESULT> lambda, List<Object> params, List<PreExecutionListener> preExecutionListeners, List<PostExecutionListener<RESULT>> postExecutionListeners, List<DefinedExceptionHandler<?>> exceptionHandlers) {
        try {
            logger.debug("Running {} pre-execution listeners.", (Object)preExecutionListeners.size());
            preExecutionListeners.forEach(listener -> listener.onPreExecute(params));
            logger.debug("Pre-execution listeners run successfully.");
            logger.debug("Executing function.");
            Object result = lambda.get();
            logger.debug("Function executed successfully.");
            logger.debug("Running {} post-execution listeners.", (Object)postExecutionListeners.size());
            postExecutionListeners.forEach(listener -> listener.onPostExecute(params, result));
            logger.debug("Post-execution listener run successfully.");
            return result;
        }
        catch (Throwable t) {
            logger.debug("{} thrown. Going through handlers.", (Object)t.getClass().getSimpleName());
            exceptionHandlers.stream().filter(handler -> handler.getHandledException().isInstance(t)).peek(handler -> logger.debug("Handler for class {} used to handle the exception.", (Object)handler.getHandledException().getName())).findFirst().orElseThrow(() -> new UnhandledException(t)).handle(t);
            return null;
        }
    }
}

