/*
 * Decompiled with CFR 0.152.
 */
package org.mule.commons.atlantic.execution.builder;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.commons.atlantic.exception.ConversionException;
import org.mule.commons.atlantic.exception.UnhandledException;
import org.mule.commons.atlantic.execution.builder.ExecutionBuilder;
import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.execution.parser.Parser;
import org.mule.commons.atlantic.lambda.AtlanticLambda;
import org.mule.commons.atlantic.lambda.function.AtlanticFunction;
import org.mule.commons.atlantic.lambda.function.TriFunction;

public abstract class GenericFunctionExecutionBuilder<A, L extends AtlanticFunction<A, D>, D extends AtlanticLambda, NEXT extends ExecutionBuilder, RESULT>
extends ExecutionBuilder<L, RESULT> {
    private final TriFunction<D, List<Object>, ExecutionContext, NEXT> nextExecutionBuilderConstructor;

    protected GenericFunctionExecutionBuilder(L lambda, List<Object> params, ExecutionContext<RESULT> context, TriFunction<D, List<Object>, ExecutionContext, NEXT> nextExecutionBuilderConstructor) {
        super(lambda, params, context);
        this.nextExecutionBuilderConstructor = nextExecutionBuilderConstructor;
    }

    public NEXT withParam(A param) {
        try {
            return (NEXT)((ExecutionBuilder)this.nextExecutionBuilderConstructor.apply(((AtlanticFunction)this.getLambda()).downgrade(param), Stream.concat(this.getParams().stream(), Stream.of(param)).collect(Collectors.toList()), this.getContext()));
        }
        catch (Throwable throwable) {
            throw new UnhandledException(throwable);
        }
    }

    public <INPUT> NEXT withParam(INPUT input, Parser<INPUT, A> parser) {
        try {
            return this.withParam(parser.apply(input));
        }
        catch (UnhandledException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new ConversionException(input, throwable);
        }
    }
}

