package org.mule.commons.atlantic.lambda.function;

import java.util.Objects;

/**
 * Represents a function that accepts nine arguments and produces a result.
 * This is the nine-arity specialization of {@link Function}.
 *
 * This is a functional interface whose functional method is {@link #apply(Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
 *
 * @param <A>      The type of the first argument to the function
 * @param <B>      The type of the second argument to the function
 * @param <C>      The type of the third argument to the function
 * @param <D>      The type of the fourth argument to the function
 * @param <E>      The type of the fifth argument to the function
 * @param <F>      The type of the sixth argument to the function
 * @param <G>      The type of the seventh argument to the function
 * @param <H>      The type of the eighth argument to the function
 * @param <I>      The type of the ninth argument to the function
 * @param <RESULT> The type of the result of the function
 */
@FunctionalInterface
public interface NonaFunction<A, B, C, D, E, F, G, H, I, RESULT> extends AtlanticFunction<A, OctaFunction<B, C, D, E, F, G, H, I, RESULT>> {

    /**
     * Applies this function to the given arguments.
     *
     * @param a The first function argument.
     * @param b The second function argument.
     * @param c The third function argument.
     * @param d The fourth function argument.
     * @param e The fifth function argument.
     * @param f The sixth function argument.
     * @param g The seventh function argument.
     * @param h The eighth function argument.
     * @param i The ninth function argument.
     * @return Object The function result.
     * @throws Throwable Any exception that the operation will throw.
     */
    RESULT apply(A a, B b, C c, D d, E e, F f, G g, H h, I i) throws Throwable;

    @Override
    default OctaFunction<B, C, D, E, F, G, H, I, RESULT> downgrade(A a) {
        return (b, c, d, e, f, g, h, i) -> apply(a, b, c, d, e, f, g, h, i);
    }

    /**
     * Returns a composed nonafunction that first applies this nonafunction to its input, and then applies the {@code after}
     * function to the result.
     * If evaluation of either function throws an exception, it is relayed to the caller of the composed function.
     *
     * @param <AFTER_RESULT> The type of output of the {@code after} function, and of the composed function.
     * @param after          The function to apply after this function is applied.
     * @return NonaFunction A composed nonafunction that first applies this function and then applies the {@code after} function
     */
    default <AFTER_RESULT> NonaFunction<A, B, C, D, E, F, G, H, I, AFTER_RESULT> andThen(Function<? super RESULT, ? extends AFTER_RESULT> after) {
        Objects.requireNonNull(after);
        return (A a, B b, C c, D d, E e, F f, G g, H h, I i) -> after.apply(apply(a, b, c, d, e, f, g, h, i));
    }
}
