package org.mule.commons.atlantic.execution.builder.factory;

import org.mule.commons.atlantic.execution.builder.BiFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.DecaFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.FunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.HeptaFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.HexaFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.NonaFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.OctaFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.PentaFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.SupplierExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.TetraFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.TriFunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.parser.Parser;
import org.mule.commons.atlantic.lambda.consumer.BiConsumer;
import org.mule.commons.atlantic.lambda.consumer.Consumer;
import org.mule.commons.atlantic.lambda.consumer.DecaConsumer;
import org.mule.commons.atlantic.lambda.consumer.HeptaConsumer;
import org.mule.commons.atlantic.lambda.consumer.HexaConsumer;
import org.mule.commons.atlantic.lambda.consumer.NonaConsumer;
import org.mule.commons.atlantic.lambda.consumer.OctaConsumer;
import org.mule.commons.atlantic.lambda.consumer.PentaConsumer;
import org.mule.commons.atlantic.lambda.consumer.TetraConsumer;
import org.mule.commons.atlantic.lambda.consumer.TriConsumer;
import org.mule.commons.atlantic.lambda.function.BiFunction;
import org.mule.commons.atlantic.lambda.function.DecaFunction;
import org.mule.commons.atlantic.lambda.function.Function;
import org.mule.commons.atlantic.lambda.function.HeptaFunction;
import org.mule.commons.atlantic.lambda.function.HexaFunction;
import org.mule.commons.atlantic.lambda.function.NonaFunction;
import org.mule.commons.atlantic.lambda.function.OctaFunction;
import org.mule.commons.atlantic.lambda.function.PentaFunction;
import org.mule.commons.atlantic.lambda.function.TetraFunction;
import org.mule.commons.atlantic.lambda.function.TriFunction;
import org.mule.commons.atlantic.lambda.runnable.Runnable;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

import static java.util.Collections.emptyList;

/**
 * ExecutionBuilderFactory in charge of executing static methods and constructors.
 *
 * This class contains a set of configuration methods an a series overloaded methods called execute.
 * Each of these execute methods allow for the execution of a different type of static method or constructor, starting
 * from no parameters to up to 10 parameters on it.
 * The configuration methods allow to set a list of pre execution listeners, another list of post execution listeners,
 * a list of exception handlers and the handler for the thread execution.
 *
 * The execution for such methods will follow the following code:
 *
 * <code>
 *     MyResult result = new StaticExecutionBuilderFactory().execute(MyClass::myStaticMethod)
 *         .withParam(param1)
 *         .withParam(param2);
 * </code>
 *
 * Where myStaticMethod is a static method on the MyClass class, param1 is the first parameter on myStaticMethod,
 * param2 is the second (and last) parameter on myStaticMethod and MyResult is the returning object of
 * myStaticMethod. This means that that execution is the equivalent of doing:
 *
 * <code>
 *     MyResult result = MyClass.myStaticMethod.myMethod(param1, param2);
 * </code>
 *
 * Optionally, an additional execution for this executor can follow the following code:
 *
 * <code>
 *     MyClass newMyClassInstance = new StaticExecutionBuilderFactory().execute(MyClass::new)
 *         .withParam(param1)
 *         .withParam(param2);
 * </code>
 *
 * Where newMyClassInstance is an instance of the MyClass class, param1 is the first parameter on the constructor,
 * param2 is the second (and last) parameter on the constructor.
 *
 * The advantage of doing this in this way is all the wrappers and listeners that we can add to the execution.
 * @param <RESULT> The type of result returned by the execution to build.
 */
public class StaticExecutionBuilderFactory<RESULT> extends ExecutionBuilderFactory<StaticExecutionBuilderFactory<RESULT>, RESULT> {

    /**
     * Starts the execution build for a {@link DecaConsumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @param <B>    The second parameter.
     * @param <C>    The third parameter.
     * @param <D>    The fourth parameter.
     * @param <E>    The fifth parameter.
     * @param <F>    The sixth parameter.
     * @param <G>    The seventh parameter.
     * @param <H>    The eight parameter.
     * @param <I>    The ninth parameter.
     * @param <J>    The tenth parameter.
     * @return DecaFunctionExecutionBuilder The builder for a function that receives 10 parameters and returns Void.
     */
    public <A, B, C, D, E, F, G, H, I, J> DecaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, I, J, Void> execute(DecaConsumer<A, B, C, D, E, F, G, H, I, J> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link DecaFunction}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <B>      The second parameter.
     * @param <C>      The third parameter.
     * @param <D>      The fourth parameter.
     * @param <E>      The fifth parameter.
     * @param <F>      The sixth parameter.
     * @param <G>      The seventh parameter.
     * @param <H>      The eight parameter.
     * @param <I>      The ninth parameter.
     * @param <J>      The tenth parameter.
     * @param <RESULT> The expected result of the execution.
     * @return DecaFunctionExecutionBuilder The builder for a function that receives 10 parameters and returns Void.
     */
    public <A, B, C, D, E, F, G, H, I, J, RESULT> DecaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, I, J, RESULT> execute(DecaFunction<A, B, C, D, E, F, G, H, I, J, RESULT> lambda) {
        return new DecaFunctionExecutionBuilder<>(lambda, emptyList(), build());
    }


    /**
     * Starts the execution build for a {@link DecaFunction} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <B>               The second parameter.
     * @param <C>               The third parameter.
     * @param <D>               The fourth parameter.
     * @param <E>               The fifth parameter.
     * @param <F>               The sixth parameter.
     * @param <G>               The seventh parameter.
     * @param <H>               The eight parameter.
     * @param <I>               The ninth parameter.
     * @param <J>               The tenth parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return DecaFunctionExecutionBuilder The builder for a function that receives 10 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, F, G, H, I, J, UNPARSED_RESULT, RESULT> DecaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, I, J, RESULT> execute(DecaFunction<A, B, C, D, E, F, G, H, I, J, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link NonaConsumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @param <B>    The second parameter.
     * @param <C>    The third parameter.
     * @param <D>    The fourth parameter.
     * @param <E>    The fifth parameter.
     * @param <F>    The sixth parameter.
     * @param <G>    The seventh parameter.
     * @param <H>    The eight parameter.
     * @param <I>    The ninth parameter.
     * @return NonaFunctionExecutionBuilder The builder for a function that receives 9 parameters and returns Void.
     */
    public <A, B, C, D, E, F, G, H, I> NonaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, I, Void> execute(NonaConsumer<A, B, C, D, E, F, G, H, I> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link NonaFunction}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <B>      The second parameter.
     * @param <C>      The third parameter.
     * @param <D>      The fourth parameter.
     * @param <E>      The fifth parameter.
     * @param <F>      The sixth parameter.
     * @param <G>      The seventh parameter.
     * @param <H>      The eight parameter.
     * @param <I>      The ninth parameter.
     * @param <RESULT> The expected result of the execution.
     * @return NonaFunctionExecutionBuilder The builder for a function that receives 9 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, F, G, H, I, RESULT> NonaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, I, RESULT> execute(NonaFunction<A, B, C, D, E, F, G, H, I, RESULT> lambda) {
        return new NonaFunctionExecutionBuilder<>(lambda, emptyList(), build());
    }

    /**
     * Starts the execution build for a {@link NonaFunction} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <B>               The second parameter.
     * @param <C>               The third parameter.
     * @param <D>               The fourth parameter.
     * @param <E>               The fifth parameter.
     * @param <F>               The sixth parameter.
     * @param <G>               The seventh parameter.
     * @param <H>               The eight parameter.
     * @param <I>               The ninth parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return NonaFunctionExecutionBuilder The builder for a function that receives 9 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, F, G, H, I, UNPARSED_RESULT, RESULT> NonaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, I, RESULT> execute(NonaFunction<A, B, C, D, E, F, G, H, I, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link OctaConsumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @param <B>    The second parameter.
     * @param <C>    The third parameter.
     * @param <D>    The fourth parameter.
     * @param <E>    The fifth parameter.
     * @param <F>    The sixth parameter.
     * @param <G>    The seventh parameter.
     * @param <H>    The eight parameter.
     * @return OctaFunctionExecutionBuilder The builder for a function that receives 8 parameters and returns Void.
     */
    public <A, B, C, D, E, F, G, H> OctaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, Void> execute(OctaConsumer<A, B, C, D, E, F, G, H> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link OctaFunction}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <B>      The second parameter.
     * @param <C>      The third parameter.
     * @param <D>      The fourth parameter.
     * @param <E>      The fifth parameter.
     * @param <F>      The sixth parameter.
     * @param <G>      The seventh parameter.
     * @param <H>      The eight parameter.
     * @param <RESULT> The expected result of the execution.
     * @return OctaFunctionExecutionBuilder The builder for a function that receives 8 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, F, G, H, RESULT> OctaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, RESULT> execute(OctaFunction<A, B, C, D, E, F, G, H, RESULT> lambda) {
        return new OctaFunctionExecutionBuilder<>(lambda, emptyList(), build());
    }

    /**
     * Starts the execution build for a {@link OctaFunction} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <B>               The second parameter.
     * @param <C>               The third parameter.
     * @param <D>               The fourth parameter.
     * @param <E>               The fifth parameter.
     * @param <F>               The sixth parameter.
     * @param <G>               The seventh parameter.
     * @param <H>               The eight parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return OctaFunctionExecutionBuilder The builder for a function that receives 8 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, F, G, H, UNPARSED_RESULT, RESULT> OctaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, RESULT> execute(OctaFunction<A, B, C, D, E, F, G, H, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link HeptaConsumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @param <B>    The second parameter.
     * @param <C>    The third parameter.
     * @param <D>    The fourth parameter.
     * @param <E>    The fifth parameter.
     * @param <F>    The sixth parameter.
     * @param <G>    The seventh parameter.
     * @return HeptaFunctionExecutionBuilder The builder for a function that receives 7 parameters and returns Void.
     */
    public <A, B, C, D, E, F, G> HeptaFunctionExecutionBuilder<A, B, C, D, E, F, G, Void> execute(HeptaConsumer<A, B, C, D, E, F, G> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link HeptaFunction}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <B>      The second parameter.
     * @param <C>      The third parameter.
     * @param <D>      The fourth parameter.
     * @param <E>      The fifth parameter.
     * @param <F>      The sixth parameter.
     * @param <G>      The seventh parameter.
     * @param <RESULT> The expected result of the execution.
     * @return HeptaFunctionExecutionBuilder The builder for a function that receives 7 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, F, G, RESULT> HeptaFunctionExecutionBuilder<A, B, C, D, E, F, G, RESULT> execute(HeptaFunction<A, B, C, D, E, F, G, RESULT> lambda) {
        return new HeptaFunctionExecutionBuilder<>(lambda, emptyList(), build());
    }

    /**
     * Starts the execution build for a {@link HeptaFunction} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <B>               The second parameter.
     * @param <C>               The third parameter.
     * @param <D>               The fourth parameter.
     * @param <E>               The fifth parameter.
     * @param <F>               The sixth parameter.
     * @param <G>               The seventh parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return HeptaFunctionExecutionBuilder The builder for a function that receives 7 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, F, G, UNPARSED_RESULT, RESULT> HeptaFunctionExecutionBuilder<A, B, C, D, E, F, G, RESULT> execute(HeptaFunction<A, B, C, D, E, F, G, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link HexaConsumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @param <B>    The second parameter.
     * @param <C>    The third parameter.
     * @param <D>    The fourth parameter.
     * @param <E>    The fifth parameter.
     * @param <F>    The sixth parameter.
     * @return HexaFunctionExecutionBuilder The builder for a function that receives 6 parameters and returns Void.
     */
    public <A, B, C, D, E, F> HexaFunctionExecutionBuilder<A, B, C, D, E, F, Void> execute(HexaConsumer<A, B, C, D, E, F> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link HexaFunction}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <B>      The second parameter.
     * @param <C>      The third parameter.
     * @param <D>      The fourth parameter.
     * @param <E>      The fifth parameter.
     * @param <F>      The sixth parameter.
     * @param <RESULT> The expected result of the execution.
     * @return HexaFunctionExecutionBuilder The builder for a function that receives 6 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, F, RESULT> HexaFunctionExecutionBuilder<A, B, C, D, E, F, RESULT> execute(HexaFunction<A, B, C, D, E, F, RESULT> lambda) {
        return new HexaFunctionExecutionBuilder<>(lambda, emptyList(), build());
    }

    /**
     * Starts the execution build for a {@link HexaFunction} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <B>               The second parameter.
     * @param <C>               The third parameter.
     * @param <D>               The fourth parameter.
     * @param <E>               The fifth parameter.
     * @param <F>               The sixth parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return HexaFunctionExecutionBuilder The builder for a function that receives 6 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, F, UNPARSED_RESULT, RESULT> HexaFunctionExecutionBuilder<A, B, C, D, E, F, RESULT> execute(HexaFunction<A, B, C, D, E, F, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link PentaConsumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @param <B>    The second parameter.
     * @param <C>    The third parameter.
     * @param <D>    The fourth parameter.
     * @param <E>    The fifth parameter.
     * @return PentaFunctionExecutionBuilder The builder for a function that receives 5 parameters and returns Void.
     */
    public <A, B, C, D, E> PentaFunctionExecutionBuilder<A, B, C, D, E, Void> execute(PentaConsumer<A, B, C, D, E> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link PentaFunction}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <B>      The second parameter.
     * @param <C>      The third parameter.
     * @param <D>      The fourth parameter.
     * @param <E>      The fifth parameter.
     * @param <RESULT> The expected result of the execution.
     * @return PentaFunctionExecutionBuilder The builder for a function that receives 5 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, RESULT> PentaFunctionExecutionBuilder<A, B, C, D, E, RESULT> execute(PentaFunction<A, B, C, D, E, RESULT> lambda) {
        return new PentaFunctionExecutionBuilder<>(lambda, emptyList(), build());
    }

    /**
     * Starts the execution build for a {@link PentaFunction} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <B>               The second parameter.
     * @param <C>               The third parameter.
     * @param <D>               The fourth parameter.
     * @param <E>               The fifth parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return PentaFunctionExecutionBuilder The builder for a function that receives 5 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, E, UNPARSED_RESULT, RESULT> PentaFunctionExecutionBuilder<A, B, C, D, E, RESULT> execute(PentaFunction<A, B, C, D, E, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link TetraConsumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @param <B>    The second parameter.
     * @param <C>    The third parameter.
     * @param <D>    The fourth parameter.
     * @return TetraFunctionExecutionBuilder The builder for a function that receives 4 parameters and returns Void.
     */
    public <A, B, C, D> TetraFunctionExecutionBuilder<A, B, C, D, Void> execute(TetraConsumer<A, B, C, D> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link TetraFunction}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <B>      The second parameter.
     * @param <C>      The third parameter.
     * @param <D>      The fourth parameter.
     * @param <RESULT> The expected result of the execution.
     * @return TetraFunctionExecutionBuilder The builder for a function that receives 4 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, RESULT> TetraFunctionExecutionBuilder<A, B, C, D, RESULT> execute(TetraFunction<A, B, C, D, RESULT> lambda) {
        return new TetraFunctionExecutionBuilder<>(lambda, emptyList(), build());
    }

    /**
     * Starts the execution build for a {@link TetraFunction} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <B>               The second parameter.
     * @param <C>               The third parameter.
     * @param <D>               The fourth parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return TetraFunctionExecutionBuilder The builder for a function that receives 4 parameters and returns a
     * determined result.
     */
    public <A, B, C, D, UNPARSED_RESULT, RESULT> TetraFunctionExecutionBuilder<A, B, C, D, RESULT> execute(TetraFunction<A, B, C, D, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link TriConsumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @param <B>    The second parameter.
     * @param <C>    The third parameter.
     * @return TriFunctionExecutionBuilder The builder for a function that receives 3 parameters and returns Void.
     */
    public <A, B, C> TriFunctionExecutionBuilder<A, B, C, Void> execute(TriConsumer<A, B, C> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link TriFunction}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <B>      The second parameter.
     * @param <C>      The third parameter.
     * @param <RESULT> The expected result of the execution.
     * @return TriFunctionExecutionBuilder The builder for a function that receives 3 parameters and returns a
     * determined result.
     */
    public <A, B, C, RESULT> TriFunctionExecutionBuilder<A, B, C, RESULT> execute(TriFunction<A, B, C, RESULT> lambda) {
        return new TriFunctionExecutionBuilder<>(lambda, emptyList(), build());
    }

    /**
     * Starts the execution build for a {@link TriFunction} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <B>               The second parameter.
     * @param <C>               The third parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return TriFunctionExecutionBuilder The builder for a function that receives 3 parameters and returns a
     * determined result.
     */
    public <A, B, C, UNPARSED_RESULT, RESULT> TriFunctionExecutionBuilder<A, B, C, RESULT> execute(TriFunction<A, B, C, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link BiConsumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @param <B>    The second parameter.
     * @return BiFunctionExecutionBuilder The builder for a function that receives 2 parameters and returns Void.
     */
    public <A, B> BiFunctionExecutionBuilder<A, B, Void> execute(BiConsumer<A, B> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link BiFunction}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <B>      The second parameter.
     * @param <RESULT> The expected result of the execution.
     * @return BiFunctionExecutionBuilder The builder for a function that receives 2 parameters and returns a
     * determined result.
     */
    public <A, B, RESULT> BiFunctionExecutionBuilder<A, B, RESULT> execute(BiFunction<A, B, RESULT> lambda) {
        return new BiFunctionExecutionBuilder<>(lambda, emptyList(), build());
    }

    /**
     * Starts the execution build for a {@link BiFunction} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <B>               The second parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return BiFunctionExecutionBuilder The builder for a function that receives 2 parameters and returns a determined
     * result.
     */
    public <A, B, UNPARSED_RESULT, RESULT> BiFunctionExecutionBuilder<A, B, RESULT> execute(BiFunction<A, B, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link Consumer}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     * @param <A>    The first parameter.
     * @return FunctionExecutionBuilder The builder for a function that receives 1 parameter and returns Void.
     */
    public <A> FunctionExecutionBuilder<A, Void> execute(Consumer<A> lambda) {
        return execute(lambda.toFunction());
    }

    /**
     * Starts the execution build for a {@link Function}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <A>      The first parameter.
     * @param <RESULT> The expected result of the execution.
     * @return FunctionExecutionBuilder The builder for a function that receives 1 parameter and returns a determined
     * result.
     */
    public <A, RESULT> FunctionExecutionBuilder<A, RESULT> execute(Function<A, RESULT> lambda) {
        return new FunctionExecutionBuilder<>(lambda, emptyList(), build());
    }

    /**
     * Starts the execution build for a {@link Function} parsing the result with a {@link Parser}. This consumer can
     * be either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <A>               The first parameter.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return FunctionExecutionBuilder The builder for a function that receives 1 parameter and returns a determined
     * result.
     */
    public <A, UNPARSED_RESULT, RESULT> FunctionExecutionBuilder<A, RESULT> execute(Function<A, UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }

    /**
     * Starts the execution build for a {@link Runnable}. This consumer can be either a static method or a constructor.
     *
     * @param lambda The consumer to execute.
     */
    public void execute(Runnable lambda) {
        execute(lambda.toSupplier());
    }

    /**
     * Starts the execution build for a {@link Supplier}. This consumer can be either a static method or a constructor.
     *
     * @param lambda   The consumer to execute.
     * @param <RESULT> The expected result of the execution.
     * @return RESULT The result of the execution.
     */
    public <RESULT> RESULT execute(Supplier<RESULT> lambda) {
        return new SupplierExecutionBuilder<>(lambda, emptyList(), build()).execute();
    }

    /**
     * Starts the execution build for a {@link Supplier} parsing the result with a {@link Parser}. This consumer can be
     * either a static method or a constructor.
     *
     * @param lambda            The consumer to execute.
     * @param resultParser      The instance of {@link Parser} that will convert from the result of the function to the
     *                          expected result.
     * @param <RESULT>          The expected result of the parsed execution.
     * @param <UNPARSED_RESULT> The result of the lambda.
     * @return RESULT The result of the execution.
     */
    public <UNPARSED_RESULT, RESULT> RESULT execute(Supplier<UNPARSED_RESULT> lambda, Parser<UNPARSED_RESULT, RESULT> resultParser) {
        return execute(lambda.andThen(resultParser));
    }
}
