package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.PentaFunction;
import org.mule.commons.atlantic.lambda.function.TetraFunction;

import java.util.List;

/**
 * {@link GenericFunctionExecutionBuilder} for {@link PentaFunction} instances.
 *
 * @param <A>      The first parameter.
 * @param <B>      The second parameter.
 * @param <C>      The third parameter.
 * @param <D>      The fourth parameter.
 * @param <E>      The fifth parameter.
 * @param <RESULT> The type of the result of the {@link PentaFunction}
 */
public class PentaFunctionExecutionBuilder<A, B, C, D, E, RESULT> extends GenericFunctionExecutionBuilder<A, PentaFunction<A, B, C, D, E, RESULT>, TetraFunction<B, C, D, E, RESULT>, TetraFunctionExecutionBuilder<B, C, D, E, RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda  The {@link PentaFunction} to execute.
     * @param params  The parameters already accumulated when creating this ExecutionBuilder.
     * @param context The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public PentaFunctionExecutionBuilder(PentaFunction<A, B, C, D, E, RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context, TetraFunctionExecutionBuilder::new);
    }
}
