package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.HeptaFunction;
import org.mule.commons.atlantic.lambda.function.OctaFunction;

import java.util.List;

/**
 * {@link GenericFunctionExecutionBuilder} for {@link OctaFunction} instances.
 *
 * @param <A>      The first parameter.
 * @param <B>      The second parameter.
 * @param <C>      The third parameter.
 * @param <D>      The fourth parameter.
 * @param <E>      The fifth parameter.
 * @param <F>      The sixth parameter.
 * @param <G>      The seventh parameter.
 * @param <H>      The eigth parameter.
 * @param <RESULT> The type of the result of the {@link OctaFunction}
 */
public class OctaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, RESULT> extends GenericFunctionExecutionBuilder<A, OctaFunction<A, B, C, D, E, F, G, H, RESULT>, HeptaFunction<B, C, D, E, F, G, H, RESULT>, HeptaFunctionExecutionBuilder<B, C, D, E, F, G, H, RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda  The {@link OctaFunction} to execute.
     * @param params  The parameters already accumulated when creating this ExecutionBuilder.
     * @param context The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public OctaFunctionExecutionBuilder(OctaFunction<A, B, C, D, E, F, G, H, RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context, HeptaFunctionExecutionBuilder::new);
    }
}
