/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.recovery;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.Uid;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryHelper {
    private static final Logger log = LoggerFactory.getLogger(RecoveryHelper.class);

    public static Set<BitronixXid> recover(XAResourceHolderState xaResourceHolderState) throws XAException {
        HashSet<BitronixXid> xids;
        block15: {
            int xidCount;
            block14: {
                xids = new HashSet<BitronixXid>();
                if (log.isDebugEnabled()) {
                    log.debug("recovering with STARTRSCAN");
                }
                try {
                    xidCount = RecoveryHelper.recover(xaResourceHolderState, xids, 0x1000000);
                }
                catch (XAException ex) {
                    if (xaResourceHolderState.getIgnoreRecoveryFailures()) {
                        if (log.isDebugEnabled()) {
                            log.debug("ignoring recovery failure on resource " + xaResourceHolderState, (Throwable)ex);
                        }
                        return Collections.emptySet();
                    }
                    throw ex;
                }
                if (log.isDebugEnabled()) {
                    log.debug("STARTRSCAN recovered " + xidCount + " xid(s) on " + xaResourceHolderState);
                }
                try {
                    while (xidCount > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("recovering with NOFLAGS");
                        }
                        xidCount = RecoveryHelper.recover(xaResourceHolderState, xids, 0);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("NOFLAGS recovered " + xidCount + " xid(s) on " + xaResourceHolderState);
                    }
                }
                catch (XAException ex) {
                    if (!log.isDebugEnabled()) break block14;
                    log.debug("NOFLAGS recovery call failed", (Throwable)ex);
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("recovering with ENDRSCAN");
                }
                xidCount = RecoveryHelper.recover(xaResourceHolderState, xids, 0x800000);
                if (log.isDebugEnabled()) {
                    log.debug("ENDRSCAN recovered " + xidCount + " xid(s) on " + xaResourceHolderState);
                }
            }
            catch (XAException ex) {
                if (!log.isDebugEnabled()) break block15;
                log.debug("ENDRSCAN recovery call failed", (Throwable)ex);
            }
        }
        return xids;
    }

    private static int recover(XAResourceHolderState resourceHolderState, Set<BitronixXid> alreadyRecoveredXids, int flags) throws XAException {
        Xid[] xids = resourceHolderState.getXAResource().recover(flags);
        if (xids == null) {
            return 0;
        }
        boolean currentNodeOnly = TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery();
        HashSet<BitronixXid> freshlyRecoveredXids = new HashSet<BitronixXid>();
        for (Xid xid : xids) {
            if (xid.getFormatId() != 1114926712) {
                if (!log.isDebugEnabled()) continue;
                log.debug("skipping non-bitronix XID " + xid + "(format ID: " + xid.getFormatId() + " GTRID: " + (xid.getGlobalTransactionId() == null ? "" : new Uid(xid.getGlobalTransactionId())) + "BQUAL: " + (xid.getBranchQualifier() == null ? "" : new Uid(xid.getBranchQualifier())) + ")");
                continue;
            }
            BitronixXid bitronixXid = new BitronixXid(xid);
            if (currentNodeOnly) {
                if (log.isDebugEnabled()) {
                    log.debug("recovering XIDs generated by this node only - recovered XIDs' GTRID must contain this JVM uniqueId");
                }
                byte[] extractedServerId = bitronixXid.getGlobalTransactionIdUid().extractServerId();
                byte[] jvmUniqueId = TransactionManagerServices.getConfiguration().buildServerIdArray();
                if (extractedServerId == null) {
                    log.error("skipping XID " + bitronixXid + " as its GTRID's serverId is null. It looks like the disk journal is corrupted!");
                    continue;
                }
                if (!Arrays.equals(jvmUniqueId, extractedServerId)) {
                    String extractedServerIdString = new String(extractedServerId);
                    String jvmUniqueIdString = new String(jvmUniqueId);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("skipping XID " + bitronixXid + " as its GTRID's serverId <" + extractedServerIdString + "> does not match this JVM unique ID <" + jvmUniqueIdString + ">");
                    continue;
                }
            } else if (log.isDebugEnabled()) {
                log.debug("recovering all XIDs regardless of this JVM uniqueId");
            }
            if (alreadyRecoveredXids.contains(bitronixXid)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("already recovered XID " + bitronixXid + ", skipping it");
                continue;
            }
            if (freshlyRecoveredXids.contains(bitronixXid)) {
                log.warn("resource " + resourceHolderState.getUniqueName() + " recovered two identical XIDs within the same recover call: " + bitronixXid);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("recovered " + bitronixXid);
            }
            freshlyRecoveredXids.add(bitronixXid);
        }
        alreadyRecoveredXids.addAll(freshlyRecoveredXids);
        return freshlyRecoveredXids.size();
    }

    public static boolean commit(XAResourceHolderState xaResourceHolderState, Xid xid) {
        String extraErrorDetails;
        String uniqueName = xaResourceHolderState.getUniqueName();
        boolean success = true;
        boolean forget = false;
        try {
            xaResourceHolderState.getXAResource().commit(xid, false);
        }
        catch (XAException ex) {
            extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            if (ex.errorCode == -4) {
                log.error("unable to commit in-doubt branch on resource " + uniqueName + " - error=XAER_NOTA" + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails) + ". Forgotten heuristic?", (Throwable)ex);
            }
            if (ex.errorCode == 7) {
                log.info("unable to commit in-doubt branch on resource " + uniqueName + " - error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails) + ". Heuristic decision compatible with the global state of this transaction.");
                forget = true;
            }
            if (ex.errorCode == 8 || ex.errorCode == 5 || ex.errorCode == 6) {
                log.error("unable to commit in-doubt branch on resource " + uniqueName + " - error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails) + ". Heuristic decision incompatible with the global state of this transaction!");
                forget = true;
                success = false;
            }
            log.error("unable to commit in-doubt branch on resource " + uniqueName + " - error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails) + ".", (Throwable)ex);
            success = false;
        }
        if (forget) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("forgetting XID " + xid + " on resource " + uniqueName);
                }
                xaResourceHolderState.getXAResource().forget(xid);
            }
            catch (XAException ex) {
                extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
                log.error("unable to forget XID " + xid + " on resource " + uniqueName + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), (Throwable)ex);
            }
        }
        return success;
    }

    public static boolean rollback(XAResourceHolderState xaResourceHolderState, Xid xid) {
        String extraErrorDetails;
        String uniqueName = xaResourceHolderState.getUniqueName();
        boolean success = true;
        boolean forget = false;
        try {
            xaResourceHolderState.getXAResource().rollback(xid);
        }
        catch (XAException ex) {
            extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            if (ex.errorCode == -4) {
                log.error("unable to rollback aborted in-doubt branch on resource " + uniqueName + " - error=XAER_NOTA" + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails) + ". Forgotten heuristic?", (Throwable)ex);
            }
            if (ex.errorCode == 6) {
                log.info("unable to rollback aborted in-doubt branch on resource " + uniqueName + " - error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails) + ". Heuristic decision compatible with the global state of this transaction.");
                forget = true;
            }
            if (ex.errorCode == 8 || ex.errorCode == 5 || ex.errorCode == 7) {
                log.error("unable to rollback aborted in-doubt branch on resource " + uniqueName + " - error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails) + ". Heuristic decision incompatible with the global state of this transaction!");
                forget = true;
                success = false;
            }
            log.error("unable to rollback aborted in-doubt branch on resource " + uniqueName + " - error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails) + ".", (Throwable)ex);
            success = false;
        }
        if (forget) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("forgetting XID " + xid + " on resource " + uniqueName);
                }
                xaResourceHolderState.getXAResource().forget(xid);
            }
            catch (XAException ex) {
                extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
                log.error("unable to forget XID " + xid + " on resource " + uniqueName + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), (Throwable)ex);
            }
        }
        return success;
    }
}

