/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.resource.jms.JmsPooledConnection;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;

public class JmsConnectionHandle
implements Connection {
    private final XAConnection xaConnection;
    private final JmsPooledConnection pooledConnection;
    private volatile boolean closed = false;

    public JmsConnectionHandle(JmsPooledConnection pooledConnection, XAConnection xaConnection) {
        this.pooledConnection = pooledConnection;
        this.xaConnection = xaConnection;
    }

    public XAConnection getXAConnection() throws JMSException {
        if (this.xaConnection == null) {
            throw new JMSException("XA connection handle has been closed");
        }
        return this.xaConnection;
    }

    public JmsPooledConnection getPooledConnection() {
        return this.pooledConnection;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.pooledConnection.createSession(transacted, acknowledgeMode);
    }

    public Session createSession(int sessionMode) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public Session createSession() throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.pooledConnection.release();
    }

    public String toString() {
        return "a JmsConnectionHandle of " + this.pooledConnection;
    }

    public String getClientID() throws JMSException {
        return this.getXAConnection().getClientID();
    }

    public void setClientID(String jndiName) throws JMSException {
        this.getXAConnection().setClientID(jndiName);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getXAConnection().getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getXAConnection().getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.getXAConnection().setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.getXAConnection().start();
    }

    public void stop() throws JMSException {
        this.getXAConnection().stop();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.getXAConnection().createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.getXAConnection().createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new RuntimeException("Method not supported");
    }
}

