/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc.executor;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.XAResourceHolderState;
import javax.transaction.xa.XAException;

public abstract class Job
implements Runnable {
    private final XAResourceHolderState resourceHolder;
    private volatile Object future;
    protected volatile XAException xaException;
    protected volatile RuntimeException runtimeException;

    public Job(XAResourceHolderState resourceHolder) {
        this.resourceHolder = resourceHolder;
    }

    public XAResourceHolderState getResource() {
        return this.resourceHolder;
    }

    public XAException getXAException() {
        return this.xaException;
    }

    public RuntimeException getRuntimeException() {
        return this.runtimeException;
    }

    public void setFuture(Object future) {
        this.future = future;
    }

    public Object getFuture() {
        return this.future;
    }

    @Override
    public final void run() {
        String oldThreadName = null;
        if (TransactionManagerServices.getConfiguration().isAsynchronous2Pc()) {
            oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("bitronix-2pc [ " + this.resourceHolder.getXid().toString() + " ]");
        }
        this.execute();
        if (oldThreadName != null) {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    protected abstract void execute();
}

