/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.model.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.api.ApiReference;

class URIApiRef
implements ApiReference {
    private URI uri;
    private Optional<ResourceLoader> resourceLoader;

    URIApiRef(URI uri) {
        this(uri, null);
    }

    URIApiRef(URI uri, ResourceLoader resourceLoader) {
        this.uri = uri;
        this.resourceLoader = Optional.ofNullable(resourceLoader);
    }

    @Override
    public String getLocation() {
        return Paths.get(this.uri).toString();
    }

    @Override
    public String getFormat() {
        return FilenameUtils.getExtension((String)this.uri.getPath()).toUpperCase();
    }

    @Override
    public InputStream resolve() {
        if (this.resourceLoader.isPresent()) {
            return this.resourceLoader.get().getResourceAsStream(this.getLocation());
        }
        try {
            return new BufferedInputStream(this.uri.toURL().openStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Optional<ResourceLoader> getResourceLoader() {
        return this.resourceLoader;
    }
}

