/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import org.mule.apikit.model.ApiVendor;

public class ApiVendorUtils {
    private static final String OPENAPI_REGEX;
    private static final String SWAGGER_REGEX;
    private static final String HEADER_RAML_10 = "#%RAML 1.0";
    private static final String HEADER_RAML_08 = "#%RAML 0.8";
    private static final Pattern OPENAPI_PATTERN;
    private static final Pattern SWAGGER_PATTERN;

    private ApiVendorUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ApiVendor deduceApiVendor(InputStream is) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(is));){
            String inputLine = ApiVendorUtils.getFirstLine(in);
            ApiVendor vendor = ApiVendorUtils.getRamlVendor(inputLine);
            if (vendor != null) {
                ApiVendor apiVendor = vendor;
                return apiVendor;
            }
            do {
                if (SWAGGER_PATTERN.matcher(inputLine).lookingAt()) {
                    ApiVendor apiVendor = ApiVendor.OAS_20;
                    return apiVendor;
                }
                if (!OPENAPI_PATTERN.matcher(inputLine).lookingAt()) continue;
                ApiVendor apiVendor = ApiVendor.OAS_30;
                return apiVendor;
            } while ((inputLine = in.readLine()) != null);
            return ApiVendor.RAML_10;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ApiVendor.RAML_10;
    }

    public static ApiVendor getRamlVendor(InputStream inputStream) {
        ApiVendor vendor = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
            String header = ApiVendorUtils.getFirstLine(in);
            vendor = ApiVendorUtils.getRamlVendor(header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return vendor;
    }

    private static ApiVendor getRamlVendor(String header) {
        if (header.toUpperCase().startsWith(HEADER_RAML_08)) {
            return ApiVendor.RAML_08;
        }
        if (header.toUpperCase().startsWith(HEADER_RAML_10)) {
            return ApiVendor.RAML_10;
        }
        return null;
    }

    private static String getFirstLine(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            return line;
        }
        return "";
    }

    static {
        String notAComment = "[^#]*";
        String maybeDoubleQuotes = "\"?";
        String maybeDoubleOrSingleQuotes = "[\"']?";
        String skipWhitespace = "\\s*";
        String matchPrefix = "[^#]*\"?\\s*";
        String matchInfix = "\\s*\"?\\s*:\\s*[\"']?\\s*";
        String matchPostfix = "\\s*[\"']?";
        OPENAPI_REGEX = "[^#]*\"?\\s*openapi\\s*\"?\\s*:\\s*[\"']?\\s*3\\.0.\\d+\\s*[\"']?";
        SWAGGER_REGEX = "[^#]*\"?\\s*swagger\\s*\"?\\s*:\\s*[\"']?\\s*2\\.0\\s*[\"']?";
        OPENAPI_PATTERN = Pattern.compile(OPENAPI_REGEX);
        SWAGGER_PATTERN = Pattern.compile(SWAGGER_REGEX);
    }
}

