/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service.strategy;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.apikit.model.ApiFormat;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.api.ApiReference;
import org.mule.parser.service.references.ReferencesResolver;
import org.mule.parser.service.result.DefaultParseResult;
import org.mule.parser.service.result.DefaultParsingIssue;
import org.mule.parser.service.result.ParseResult;
import org.mule.parser.service.result.ParsingIssue;
import org.mule.parser.service.strategy.AMFParsingStrategy;
import org.mule.parser.service.strategy.ParsingStrategy;
import org.mule.parser.service.strategy.RamlParsingStrategy;

public class WithFallbackParsingStrategy
implements ParsingStrategy {
    private static final AMFParsingStrategy AMF_DELEGATE = new AMFParsingStrategy();
    private ScheduledExecutorService executor;
    private static final String AMF_TITLE = "AMF: ";
    private static final String RAML_TITLE = "RAML: ";

    @Override
    public ParseResult parse(ApiReference ref) {
        ParseResult parseResult = AMF_DELEGATE.parse(ref);
        if (!parseResult.success() && ApiFormat.RAML.name().equalsIgnoreCase(ref.getFormat())) {
            ReferencesResolver referencesResolver = this.createReferencesResolver(parseResult);
            ParseResult ramlResult = new RamlParsingStrategy(referencesResolver).parse(ref);
            List<ParsingIssue> errors = this.joinParsingIssues(parseResult.getErrors(), ramlResult.getErrors());
            List<ParsingIssue> warnings = this.joinParsingIssues(parseResult.getWarnings(), ramlResult.getWarnings());
            return new FallbackParseResult(this.createDelegate(ramlResult, errors, warnings));
        }
        return parseResult;
    }

    private DefaultParseResult createDelegate(ParseResult ramlResult, List<ParsingIssue> sourceErrors, List<ParsingIssue> sourceWarnings) {
        if (!ramlResult.success()) {
            return new DefaultParseResult(ramlResult.get(), sourceErrors, sourceWarnings);
        }
        return new DefaultParseResult(ramlResult.get(), Collections.emptyList(), sourceErrors);
    }

    private ReferencesResolver createReferencesResolver(ParseResult amfResult) {
        ReferencesResolver referencesResolver = new ReferencesResolver(amfResult);
        if (this.executor != null) {
            referencesResolver.setExecutor(this.executor);
        }
        return referencesResolver;
    }

    private List<ParsingIssue> joinParsingIssues(List<ParsingIssue> amfIssues, List<ParsingIssue> ramlIssues) {
        Stream<DefaultParsingIssue> amfIssuesWithTitle = amfIssues.stream().map(issue -> new DefaultParsingIssue(AMF_TITLE + issue.cause()));
        Stream<DefaultParsingIssue> ramlIssuesWithTitle = ramlIssues.stream().map(issue -> new DefaultParsingIssue(RAML_TITLE + issue.cause()));
        return Stream.concat(amfIssuesWithTitle, ramlIssuesWithTitle).collect(Collectors.toList());
    }

    @Override
    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        AMF_DELEGATE.setExecutor(executor);
    }

    public class FallbackParseResult
    implements ParseResult {
        private final ParseResult delegate;

        FallbackParseResult(ParseResult delegate) {
            this.delegate = delegate;
        }

        @Override
        public ApiSpecification get() {
            return this.delegate.get();
        }

        @Override
        public boolean success() {
            return this.delegate.success();
        }

        @Override
        public List<ParsingIssue> getErrors() {
            return this.delegate.getErrors();
        }

        @Override
        public List<ParsingIssue> getWarnings() {
            return ImmutableList.builder().add((Object)new DefaultParsingIssue("AMF parsing failed, fallback into RAML parser")).addAll(this.delegate.getWarnings()).build();
        }
    }
}

