/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs;

import org.mule.apache.xerces.impl.xs.util.StringListImpl;
import org.mule.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xs.StringList;
import org.mule.apache.xerces.xs.XSAnnotation;
import org.mule.apache.xerces.xs.XSNamespaceItem;
import org.mule.apache.xerces.xs.XSObjectList;
import org.mule.apache.xerces.xs.XSWildcard;

public class XSWildcardDecl
implements XSWildcard {
    public static final String ABSENT = null;
    public short fType = 1;
    public short fProcessContents = 1;
    public String[] fNamespaceList;
    public XSObjectList fAnnotations = null;
    public QName[] fDisallowedNamesList = null;
    public boolean fDisallowedDefined = false;
    public boolean fDisallowedSibling = false;
    private String fDescription = null;

    public boolean allowNamespace(String namespace) {
        if (this.fType == 1) {
            return true;
        }
        if (this.fType == 2) {
            boolean found = false;
            int listNum = this.fNamespaceList.length;
            for (int i = 0; i < listNum && !found; ++i) {
                if (namespace != this.fNamespaceList[i]) continue;
                found = true;
            }
            if (!found) {
                return true;
            }
        }
        if (this.fType == 3) {
            int listNum = this.fNamespaceList.length;
            for (int i = 0; i < listNum; ++i) {
                if (namespace != this.fNamespaceList[i]) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean allowQName(QName name) {
        return this.allowName(name.uri, name.localpart);
    }

    public final boolean allowName(String uri, String localPart) {
        if (this.allowNamespace(uri)) {
            if (this.fDisallowedNamesList == null || this.fDisallowedNamesList.length == 0) {
                return true;
            }
            return this.isNameAllowed(uri, localPart);
        }
        return false;
    }

    private boolean isNameAllowed(String namespace, String localpart) {
        for (int i = 0; i < this.fDisallowedNamesList.length; ++i) {
            if (this.fDisallowedNamesList[i].uri != namespace || this.fDisallowedNamesList[i].localpart != localpart) continue;
            return false;
        }
        return true;
    }

    public boolean weakerProcessContents(XSWildcardDecl superWildcard) {
        return this.fProcessContents == 3 && superWildcard.fProcessContents == 1 || this.fProcessContents == 2 && superWildcard.fProcessContents != 2;
    }

    public String toString() {
        if (this.fDescription == null) {
            int i;
            StringBuffer buffer = new StringBuffer();
            buffer.append("WC[");
            switch (this.fType) {
                case 1: {
                    buffer.append("##any");
                    break;
                }
                case 2: {
                    buffer.append("##other");
                    buffer.append(':');
                }
                case 3: {
                    if (this.fNamespaceList.length == 0) break;
                    buffer.append("\"");
                    if (this.fNamespaceList[0] != null) {
                        buffer.append(this.fNamespaceList[0]);
                    }
                    buffer.append("\"");
                    for (i = 1; i < this.fNamespaceList.length; ++i) {
                        buffer.append(",\"");
                        if (this.fNamespaceList[i] != null) {
                            buffer.append(this.fNamespaceList[i]);
                        }
                        buffer.append("\"");
                    }
                    break;
                }
            }
            if (this.fDisallowedNamesList != null) {
                buffer.append(", notQName(");
                if (this.fDisallowedNamesList.length > 0) {
                    buffer.append(this.fDisallowedNamesList[0]);
                    for (i = 1; i < this.fDisallowedNamesList.length; ++i) {
                        buffer.append(", ");
                        buffer.append(this.fDisallowedNamesList[i]);
                    }
                }
                if (this.fDisallowedDefined) {
                    buffer.append(", ");
                    buffer.append("##defined");
                }
                if (this.fDisallowedSibling) {
                    buffer.append(", ");
                    buffer.append("##definedSibling");
                }
                buffer.append(')');
            }
            buffer.append(']');
            this.fDescription = buffer.toString();
        }
        return this.fDescription;
    }

    @Override
    public short getType() {
        return 9;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public short getConstraintType() {
        return this.fType;
    }

    @Override
    public StringList getNsConstraintList() {
        return new StringListImpl(this.fNamespaceList, this.fNamespaceList == null ? 0 : this.fNamespaceList.length);
    }

    @Override
    public short getProcessContents() {
        return this.fProcessContents;
    }

    public String getProcessContentsAsString() {
        switch (this.fProcessContents) {
            case 2: {
                return "skip";
            }
            case 3: {
                return "lax";
            }
            case 1: {
                return "strict";
            }
        }
        return "invalid value";
    }

    @Override
    public XSAnnotation getAnnotation() {
        return this.fAnnotations != null ? (XSAnnotation)this.fAnnotations.item(0) : null;
    }

    @Override
    public XSObjectList getAnnotations() {
        return this.fAnnotations != null ? this.fAnnotations : XSObjectListImpl.EMPTY_LIST;
    }

    @Override
    public XSNamespaceItem getNamespaceItem() {
        return null;
    }
}

