/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs;

import org.mule.apache.xerces.dom.DOMMessageFormatter;
import org.mule.apache.xerces.dom.PSVIDOMImplementationImpl;
import org.mule.apache.xerces.impl.xs.XSLoaderImpl;
import org.mule.apache.xerces.impl.xs.util.LSInputListImpl;
import org.mule.apache.xerces.impl.xs.util.StringListImpl;
import org.mule.apache.xerces.xs.LSInputList;
import org.mule.apache.xerces.xs.StringList;
import org.mule.apache.xerces.xs.XSException;
import org.mule.apache.xerces.xs.XSImplementation;
import org.mule.apache.xerces.xs.XSLoader;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.LSInput;

public class XSImplementationImpl
extends PSVIDOMImplementationImpl
implements XSImplementation {
    static final XSImplementationImpl singleton = new XSImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    @Override
    public boolean hasFeature(String feature, String version) {
        return feature.equalsIgnoreCase("XS-Loader") && (version == null || version.equals("1.0")) || super.hasFeature(feature, version);
    }

    @Override
    public XSLoader createXSLoader(StringList versions) throws XSException {
        XSLoaderImpl loader = new XSLoaderImpl();
        if (versions == null) {
            return loader;
        }
        for (int i = 0; i < versions.getLength(); ++i) {
            if (versions.item(i).equals("1.0")) continue;
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{versions.item(i)});
            throw new XSException(1, msg);
        }
        return loader;
    }

    @Override
    public StringList createStringList(String[] values) {
        int length = values != null ? values.length : 0;
        return length != 0 ? new StringListImpl((String[])values.clone(), length) : StringListImpl.EMPTY_LIST;
    }

    @Override
    public LSInputList createLSInputList(LSInput[] values) {
        int length = values != null ? values.length : 0;
        return length != 0 ? new LSInputListImpl((LSInput[])values.clone(), length) : LSInputListImpl.EMPTY_LIST;
    }

    @Override
    public StringList getRecognizedVersions() {
        StringListImpl list = new StringListImpl(new String[]{"1.0"}, 1);
        return list;
    }
}

